/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.LineAttribute;
import sgtplot.StrokeDrawer;

public class StrokeDrawer2
implements StrokeDrawer,
Cloneable {
    @Override
    public void drawHeavy(VectorGraphics g2, int[] xout, int[] yout, int size, LineAttribute attr) {
        Stroke saved = g2.getStroke();
        BasicStroke stroke = new BasicStroke(attr.getWidth());
        g2.setStroke((Stroke)stroke);
        g2.drawPolyline(xout, yout, size);
        g2.setStroke(saved);
    }

    @Override
    public void drawDashed(VectorGraphics g2, int[] xout, int[] yout, int size, LineAttribute attr) {
        Stroke saved = g2.getStroke();
        float[] dashes = new float[]{4.0f, 4.0f};
        BasicStroke stroke = new BasicStroke(1.0f, 2, 0, 10.0f, dashes, 0.0f);
        g2.setStroke((Stroke)stroke);
        g2.drawPolyline(xout, yout, size);
        g2.setStroke(saved);
    }

    @Override
    public void drawStroke(VectorGraphics g2, int[] xout, int[] yout, int size, LineAttribute attr) {
        Stroke saved = g2.getStroke();
        float[] arr = attr.getDashArray();
        BasicStroke stroke = arr == null || arr.length <= 1 ? new BasicStroke(attr.getWidth(), attr.getCapStyle(), attr.getMiterStyle(), attr.getMiterLimit()) : new BasicStroke(attr.getWidth(), attr.getCapStyle(), attr.getMiterStyle(), attr.getMiterLimit(), attr.getDashArray(), attr.getDashPhase());
        g2.setStroke((Stroke)stroke);
        g2.drawPolyline(xout, yout, size);
        g2.setStroke(saved);
    }

    @Override
    public void drawHighlight(VectorGraphics g2, int[] xout, int[] yout, int size, LineAttribute attr) {
        Stroke saved = g2.getStroke();
        BasicStroke stroke = new BasicStroke(2.75f);
        Color col = attr.getColor();
        Color rev = new Color(255 - col.getRed(), 255 - col.getGreen(), 255 - col.getBlue());
        g2.setColor(rev);
        g2.setStroke((Stroke)stroke);
        g2.drawPolyline(xout, yout, size);
        g2.setColor(col);
        g2.setStroke(saved);
        g2.drawPolyline(xout, yout, size);
    }
}

