/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import sgtplot.AxisTransform;
import sgtplot.MethodNotImplementedError;
import sgtplot.NegativeLogException;
import sgtplot.util.GeoDate;
import sgtplot.util.Range2D;
import sgtplot.util.SoTRange;
import sgtplot.util.SoTValue;
import sgtplot.util.TimeRange;

public class LogTransform
extends AxisTransform
implements Cloneable {
    double at_;
    double bt_;
    double a_;
    double b_;
    int min_ = -50;

    public LogTransform() {
    }

    public LogTransform(double p1, double p2, double u1, double u2) {
        super(p1, p2, u1, u2);
    }

    public LogTransform(Range2D pr, Range2D ur) {
        super(pr, ur);
    }

    public LogTransform(double p1, double p2, GeoDate t1, GeoDate t2) {
        super(p1, p2, t1, t2);
    }

    public LogTransform(Range2D pr, TimeRange tr) {
        super(pr, tr);
    }

    public LogTransform(Range2D pr, SoTRange str) {
        super(pr, str);
    }

    @Override
    AxisTransform copy() {
        LogTransform newTransform;
        try {
            newTransform = (LogTransform)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newTransform = new LogTransform();
        }
        return newTransform;
    }

    @Override
    public double getTransP(double u) {
        try {
            if (this.u1_ <= 0.0 || this.u2_ <= 0.0) {
                throw new NegativeLogException("Can't Log negative values");
            }
        }
        catch (NegativeLogException e) {
            e.printStackTrace();
        }
        return this.a_ * (Math.log(u) / Math.log(10.0)) + this.b_;
    }

    @Override
    public double getTransP(GeoDate t) {
        throw new MethodNotImplementedError();
    }

    @Override
    public double getTransP(long t) {
        throw new MethodNotImplementedError();
    }

    @Override
    public double getTransP(SoTValue v) {
        if (v.isTime()) {
            throw new MethodNotImplementedError();
        }
        double u = ((SoTValue.Double)v).getValue();
        try {
            if (u <= 0.0) {
                throw new NegativeLogException("Can't Log negative values");
            }
        }
        catch (NegativeLogException e) {
            e.printStackTrace();
        }
        return this.a_ * (Math.log(u) / Math.log(10.0)) + this.b_;
    }

    @Override
    public double getTransU(double p) {
        if ((p - this.b_) / this.a_ < (double)this.min_) {
            return Math.pow(10.0, this.min_);
        }
        return Math.pow(10.0, (p - this.b_) / this.a_);
    }

    @Override
    public GeoDate getTimeTransU(double p) {
        throw new MethodNotImplementedError();
    }

    @Override
    public long getLongTimeTransU(double p) {
        throw new MethodNotImplementedError();
    }

    @Override
    public SoTValue getSoTTransU(double p) {
        if ((p - this.b_) / this.a_ < (double)this.min_) {
            return new SoTValue.Double(Math.pow(10.0, this.min_));
        }
        return new SoTValue.Double(Math.pow(10.0, (p - this.b_) / this.a_));
    }

    @Override
    void computeTransform() {
        try {
            if (this.u1_ <= 0.0 || this.u2_ <= 0.0) {
                throw new NegativeLogException("Can't Log negative values");
            }
        }
        catch (NegativeLogException e) {
            e.printStackTrace();
        }
        double denom = Math.log(this.u1_) / Math.log(10.0) - Math.log(this.u2_) / Math.log(10.0);
        if (denom == 0.0) {
            this.a_ = 1.0;
            this.b_ = 0.0;
        } else {
            this.a_ = (this.p1_ - this.p2_) / denom;
            this.b_ = this.p1_ - this.a_ * (Math.log(this.u1_) / Math.log(10.0));
        }
    }

    public void setMinValue(int minVal) {
        this.min_ = minVal;
    }

    public int getMinValue() {
        return this.min_;
    }
}

