/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.Attribute;
import sgtplot.CartesianGraph;
import sgtplot.CartesianRenderer;
import sgtplot.Layer;
import sgtplot.LineAttribute;
import sgtplot.PaneProxy;
import sgtplot.PlotMark;
import sgtplot.StrokeDrawer;
import sgtplot.dm.Collection;
import sgtplot.dm.SGTData;
import sgtplot.dm.SGTLine;

public class LineCartesianRenderer
extends CartesianRenderer {
    private LineAttribute attr_ = null;
    private SGTLine line_ = null;
    private Collection collection_ = null;
    private StrokeDrawer stroke_ = null;

    @Override
    public Attribute getAttribute() {
        return this.attr_;
    }

    private void drawLine(VectorGraphics g, SGTLine line, LineAttribute attr) {
        int[] yp;
        int count;
        int[] xp;
        int size;
        if (line.isXTime()) {
            long[] xTValues = line.getGeoDateArray().getTime();
            size = xTValues.length;
            xp = new int[size];
            for (count = 0; count < size; ++count) {
                xp[count] = this.cg_.getXUtoD(xTValues[count]);
            }
        } else {
            double[] xValues = line.getXArray();
            size = xValues.length;
            xp = new int[size];
            for (count = 0; count < size; ++count) {
                xp[count] = this.cg_.getXUtoD(xValues[count]);
            }
        }
        if (line.isYTime()) {
            long[] yTValues = line.getGeoDateArray().getTime();
            size = yTValues.length;
            yp = new int[size];
            for (count = 0; count < size; ++count) {
                yp[count] = this.cg_.getYUtoD(yTValues[count]);
            }
        } else {
            double[] yValues = line.getYArray();
            size = yValues.length;
            yp = new int[size];
            for (count = 0; count < size; ++count) {
                yp[count] = this.cg_.getYUtoD(yValues[count]);
            }
        }
        int first = 0;
        int lsize = 0;
        int[] xout = new int[size];
        int[] yout = new int[size];
        block12: while (first < size) {
            int nout = -1;
            for (count = first; count < size; ++count) {
                if (xp[count] != Integer.MIN_VALUE && yp[count] != Integer.MIN_VALUE) {
                    xout[++nout] = xp[count];
                    yout[nout] = yp[count];
                    continue;
                }
                if (nout >= 0) break;
            }
            first = count + 1;
            lsize = nout + 1;
            if (lsize <= 0) {
                return;
            }
            switch (attr.getStyle()) {
                case 4: {
                    this.drawMark(g, xout, yout, lsize, attr);
                    continue block12;
                }
                case 3: {
                    this.stroke_.drawHighlight(g, xout, yout, lsize, attr);
                    continue block12;
                }
                case 2: {
                    this.stroke_.drawHeavy(g, xout, yout, lsize, attr);
                    continue block12;
                }
                case 1: {
                    this.stroke_.drawDashed(g, xout, yout, lsize, attr);
                    continue block12;
                }
                case 6: {
                    this.stroke_.drawStroke(g, xout, yout, lsize, attr);
                    continue block12;
                }
                case 5: {
                    this.drawMark(g, xout, yout, lsize, attr);
                }
            }
            g.drawPolyline(xout, yout, lsize);
        }
    }

    protected void drawMark(VectorGraphics g, int[] xp, int[] yp, int npoints, LineAttribute attr) {
        Layer ly = this.cg_.getLayer();
        PlotMark pm = new PlotMark(attr);
        for (int i = 0; i < npoints; ++i) {
            pm.paintMark(g, ly, xp[i], yp[i]);
        }
    }

    public LineCartesianRenderer(CartesianGraph cg) {
        this(cg, (SGTLine)null, null);
    }

    public LineCartesianRenderer(CartesianGraph cg, SGTLine line) {
        this(cg, line, null);
        this.cg_ = cg;
        this.line_ = line;
    }

    public LineCartesianRenderer(CartesianGraph cg, SGTLine line, LineAttribute attr) {
        this.cg_ = cg;
        this.line_ = line;
        this.attr_ = attr;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(this);
        }
        this.stroke_ = PaneProxy.strokeDrawer;
    }

    public LineCartesianRenderer(CartesianGraph cg, Collection col, LineAttribute attr) {
        this.cg_ = cg;
        this.collection_ = col;
        this.attr_ = attr;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(this);
        }
        this.stroke_ = PaneProxy.strokeDrawer;
    }

    @Override
    public void draw(VectorGraphics g) {
        if (this.cg_.clipping_) {
            int height;
            int y;
            int width;
            int x;
            int ymax;
            int ymin;
            int xmax;
            int xmin;
            if (this.cg_.xTransform_.isSpace()) {
                xmin = this.cg_.getXUtoD(this.cg_.xClipRange_.start);
                xmax = this.cg_.getXUtoD(this.cg_.xClipRange_.end);
            } else {
                xmin = this.cg_.getXUtoD(this.cg_.tClipRange_.start);
                xmax = this.cg_.getXUtoD(this.cg_.tClipRange_.end);
            }
            if (this.cg_.yTransform_.isSpace()) {
                ymin = this.cg_.getYUtoD(this.cg_.yClipRange_.start);
                ymax = this.cg_.getYUtoD(this.cg_.yClipRange_.end);
            } else {
                ymin = this.cg_.getYUtoD(this.cg_.tClipRange_.start);
                ymax = this.cg_.getYUtoD(this.cg_.tClipRange_.end);
            }
            if (xmin < xmax) {
                x = xmin;
                width = xmax - xmin;
            } else {
                x = xmax;
                width = xmin - xmax;
            }
            if (ymin < ymax) {
                y = ymin;
                height = ymax - ymin;
            } else {
                y = ymax;
                height = ymin - ymax;
            }
            g.setClip(x, y, width, height);
        }
        LineAttribute attr = this.attr_ == null ? new LineAttribute(0, this.cg_.getPane().getComponent().getForeground()) : this.attr_;
        g.setColor(attr.getColor());
        if (this.collection_ == null) {
            this.drawLine(g, this.line_, attr);
        } else {
            Enumeration li = this.collection_.elements();
            while (li.hasMoreElements()) {
                Object line = li.nextElement();
                if (!(line instanceof SGTLine)) continue;
                this.drawLine(g, (SGTLine)line, attr);
            }
        }
        Rectangle rect = this.cg_.getLayer().getPane().getBounds();
        g.setClip((Shape)rect);
    }

    public void setLineAttribute(LineAttribute l) {
        if (this.attr_ != null) {
            this.attr_.removePropertyChangeListener(this);
        }
        this.attr_ = l;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(this);
        }
    }

    public LineAttribute getLineAttribute() {
        return this.attr_;
    }

    public boolean hasCollection() {
        return this.collection_ != null;
    }

    public Collection getCollection() {
        return this.collection_;
    }

    public SGTLine getLine() {
        return this.line_;
    }

    @Override
    public CartesianGraph getCartesianGraph() {
        return this.cg_;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.modified("LineCartesianRenderer: propertyChange(" + evt.getSource().toString() + "[" + evt.getPropertyName() + "])");
    }

    @Override
    public SGTData getDataAt(Point pt) {
        return null;
    }
}

