/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import sgtplot.TimeAxisStyle;
import sgtplot.util.GeoDate;
import sgtplot.util.IllegalTimeValue;
import sgtplot.util.TimeRange;

class HourDayAxis
implements TimeAxisStyle {
    static final int HOUR_TEST__ = 4;
    static final String defaultMinorLabelFormat__ = "HH";
    static final String defaultMajorLabelFormat__ = "yyyy-MM-dd";
    static final int defaultNumSmallTics__ = 0;
    int defaultMinorLabelInterval_ = 2;
    int defaultMajorLabelInterval_ = 1;
    static final double incrementValue__ = 1.0;
    static final int incrementUnits__ = 5;

    @Override
    public double computeLocation(double prev, double now) {
        return prev;
    }

    @Override
    public void computeDefaults(GeoDate delta) {
        long days = delta.getTime() / 86400000L;
        long msec = delta.getTime() % 86400000L;
        this.defaultMinorLabelInterval_ = days > 2L ? 6 : (days > 0L || msec > 43200000L ? 2 : 1);
    }

    @Override
    public int getMinorValue(GeoDate time) {
        return time.getGMTHours();
    }

    @Override
    public int getMajorValue(GeoDate time) {
        return time.getGMTDay();
    }

    @Override
    public boolean isRoomForMajorLabel(GeoDate delta) {
        return 24.0 * ((double)delta.getTime() / 8.64E7) > 4.0;
    }

    @Override
    public boolean isStartOfMinor(GeoDate time) {
        return time.getGMTHours() == 0;
    }

    @Override
    public String getDefaultMinorLabelFormat() {
        return defaultMinorLabelFormat__;
    }

    @Override
    public String getDefaultMajorLabelFormat() {
        return defaultMajorLabelFormat__;
    }

    @Override
    public int getDefaultNumSmallTics() {
        return 0;
    }

    @Override
    public int getDefaultMinorLabelInterval() {
        return this.defaultMinorLabelInterval_;
    }

    @Override
    public int getDefaultMajorLabelInterval() {
        return this.defaultMajorLabelInterval_;
    }

    @Override
    public GeoDate getStartTime(TimeRange tRange) {
        GeoDate time = null;
        boolean time_increasing = tRange.end.after(tRange.start);
        try {
            if (time_increasing) {
                time = new GeoDate(tRange.start.getGMTMonth(), tRange.start.getGMTDay(), tRange.start.getGMTYear(), tRange.start.getGMTHours(), 0, 0, 0);
                if (!time.equals(tRange.start)) {
                    time.increment(1.0f, 5);
                }
            } else {
                time = new GeoDate(tRange.end.getGMTMonth(), tRange.end.getGMTDay(), tRange.end.getGMTYear(), tRange.end.getGMTHours(), 0, 0, 0);
                if (!time.equals(tRange.end)) {
                    time.increment(1.0f, 5);
                }
            }
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        return time;
    }

    @Override
    public double getIncrementValue() {
        return 1.0;
    }

    @Override
    public int getIncrementUnits() {
        return 5;
    }

    @Override
    public String toString() {
        return "HourDayAxis";
    }
}

