/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import sgtplot.Attribute;
import sgtplot.AttributeChangeEvent;
import sgtplot.ColorMap;
import sgtplot.ContourLevels;

public class GridAttribute
implements Attribute,
Cloneable,
PropertyChangeListener {
    private transient PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private static final long serialVersionUID = 3822340406728567524L;
    private boolean batch_ = false;
    private boolean local_ = true;
    private boolean modified_ = false;
    private String id_ = null;
    private ColorMap cmap_;
    private ContourLevels clev_;
    private int style_;
    public static final int RASTER = 0;
    public static final int AREA_FILL = 1;
    public static final int CONTOUR = 2;
    public static final int RASTER_CONTOUR = 3;
    public static final int AREA_FILL_CONTOUR = 4;

    public GridAttribute() {
        this(0, null);
    }

    public GridAttribute(int style, ColorMap cmap) {
        this.style_ = style;
        this.cmap_ = cmap;
        if (this.cmap_ != null) {
            this.cmap_.addPropertyChangeListener(this);
        }
    }

    public GridAttribute(ContourLevels clev) {
        this.style_ = 2;
        this.cmap_ = null;
        this.clev_ = clev;
    }

    public void setContourLevels(ContourLevels clev) {
        if (this.clev_ == null || !this.clev_.equals(clev)) {
            ContourLevels tempOld = this.clev_;
            this.clev_ = clev;
            this.firePropertyChange("contourLevels", tempOld, this.clev_);
        }
    }

    public ContourLevels getContourLevels() {
        return this.clev_;
    }

    public GridAttribute copy() {
        GridAttribute newGrid;
        try {
            newGrid = (GridAttribute)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newGrid = new GridAttribute();
        }
        return newGrid;
    }

    public void setStyle(int st) {
        if (this.style_ != st) {
            Integer tempOld = new Integer(this.style_);
            this.style_ = st;
            this.firePropertyChange("style", tempOld, new Integer(this.style_));
        }
    }

    public int getStyle() {
        return this.style_;
    }

    public boolean isRaster() {
        return this.style_ == 0 || this.style_ == 3;
    }

    public boolean isContour() {
        return this.style_ == 2 || this.style_ == 3 || this.style_ == 4;
    }

    public boolean isAreaFill() {
        return this.style_ == 1 || this.style_ == 4;
    }

    public ColorMap getColorMap() {
        return this.cmap_;
    }

    public void setColorMap(ColorMap cmap) {
        if (this.cmap_ == null && cmap == null) {
            return;
        }
        if (this.cmap_ != null) {
            this.cmap_.removePropertyChangeListener(this);
        }
        if (this.cmap_ == null || !this.cmap_.equals(cmap)) {
            ColorMap tempOld = this.cmap_;
            this.cmap_ = cmap;
            this.firePropertyChange("colorMap", tempOld, this.cmap_);
            this.cmap_.addPropertyChangeListener(this);
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes_.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.changes_.firePropertyChange(evt);
    }

    @Override
    public void setId(String id) {
        this.id_ = id;
    }

    @Override
    public String getId() {
        return this.id_;
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (this.batch_) {
            this.modified_ = true;
            return;
        }
        AttributeChangeEvent ace = new AttributeChangeEvent(this, name, oldValue, newValue, this.local_);
        this.changes_.firePropertyChange(ace);
        this.modified_ = false;
    }

    @Override
    public void setBatch(boolean batch) {
        this.setBatch(batch, true);
    }

    @Override
    public void setBatch(boolean batch, boolean local) {
        this.local_ = local;
        this.batch_ = batch;
        if (!batch && this.modified_) {
            this.firePropertyChange("batch", Boolean.TRUE, Boolean.FALSE);
        }
    }

    @Override
    public boolean isBatch() {
        return this.batch_;
    }
}

