/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import sgtplot.AttributeChangeEvent;
import sgtplot.util.Range2D;

public abstract class ColorMap
implements Cloneable,
PropertyChangeListener,
Serializable {
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    protected boolean batch_ = false;
    protected boolean local_ = true;
    protected boolean modified_ = false;

    public abstract ColorMap copy();

    public abstract Color getColor(double var1);

    public abstract Range2D getRange();

    public abstract boolean equals(ColorMap var1);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes_.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes_.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (this.batch_) {
            this.modified_ = true;
            return;
        }
        AttributeChangeEvent ace = new AttributeChangeEvent(this, name, oldValue, newValue, this.local_);
        this.changes_.firePropertyChange(ace);
        this.modified_ = false;
    }

    public void setBatch(boolean batch) {
        this.setBatch(batch, true);
    }

    public void setBatch(boolean batch, boolean local) {
        this.local_ = local;
        this.batch_ = batch;
        if (!batch && this.modified_) {
            this.firePropertyChange("batch", Boolean.TRUE, Boolean.FALSE);
        }
    }

    public boolean isBatch() {
        return this.batch_;
    }
}

