/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import java.awt.Point;
import java.beans.PropertyChangeListener;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.AbstractPane;
import sgtplot.AnnotationCartesianRenderer;
import sgtplot.Attribute;
import sgtplot.CartesianGraph;
import sgtplot.GridAttribute;
import sgtplot.GridCartesianRenderer;
import sgtplot.LineAttribute;
import sgtplot.LineCartesianRenderer;
import sgtplot.PointAttribute;
import sgtplot.PointCartesianRenderer;
import sgtplot.VectorAttribute;
import sgtplot.VectorCartesianRenderer;
import sgtplot.dm.Annotation;
import sgtplot.dm.Collection;
import sgtplot.dm.SGTData;
import sgtplot.dm.SGTGrid;
import sgtplot.dm.SGTLine;
import sgtplot.dm.SGTPoint;
import sgtplot.dm.SGTVector;

public abstract class CartesianRenderer
implements PropertyChangeListener {
    protected CartesianGraph cg_;

    public static CartesianRenderer getRenderer(CartesianGraph cg, SGTData dmo, Attribute attr) {
        if (dmo instanceof SGTPoint) {
            return new PointCartesianRenderer(cg, (SGTPoint)dmo, (PointAttribute)attr);
        }
        if (dmo instanceof SGTLine) {
            return new LineCartesianRenderer(cg, (SGTLine)dmo, (LineAttribute)attr);
        }
        if (dmo instanceof SGTGrid) {
            return new GridCartesianRenderer(cg, (SGTGrid)dmo, (GridAttribute)attr);
        }
        if (dmo instanceof SGTVector) {
            return new VectorCartesianRenderer(cg, (SGTVector)dmo, (VectorAttribute)attr);
        }
        if (dmo instanceof Collection) {
            Object fe = ((Collection)dmo).firstElement();
            if (fe instanceof SGTPoint) {
                return new PointCartesianRenderer(cg, (Collection)dmo, (PointAttribute)attr);
            }
            if (fe instanceof SGTLine) {
                return new LineCartesianRenderer(cg, (Collection)dmo, (LineAttribute)attr);
            }
            if (fe instanceof SGTVector) {
                return new VectorCartesianRenderer(cg, (Collection)dmo, (VectorAttribute)attr);
            }
        } else if (dmo instanceof Annotation) {
            return new AnnotationCartesianRenderer(cg, (Annotation)dmo, null);
        }
        return null;
    }

    public abstract void draw(VectorGraphics var1);

    public abstract Attribute getAttribute();

    public abstract CartesianGraph getCartesianGraph();

    public AbstractPane getPane() {
        return this.cg_.getPane();
    }

    public void modified(String mess) {
        if (this.cg_ != null) {
            this.cg_.modified(mess);
        }
    }

    public SGTData getDataAt(int x, int y) {
        return this.getDataAt(new Point(x, y));
    }

    public abstract SGTData getDataAt(Point var1);
}

