/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.demo;

import ptolemy.plot.Plot;
import ptolemy.plot.PlotApplet;

public class PlotFourierSeries
extends PlotApplet {
    @Override
    public String getAppletInfo() {
        return "PlotFourierSeries 1.1: Demo of PlotApplet.\nBy: Edward A. Lee\n ($Id: PlotFourierSeries.java,v 1.45 2006/03/29 00:01:41 cxh Exp $)";
    }

    @Override
    public void init() {
        super.init();
        Plot plot = (Plot)this.plot();
        plot.setTitle("Fourier Series Approximation to a Square Wave");
        plot.setXRange(0.0, 400.0);
        plot.setMarksStyle("none");
        plot.addLegend(0, "ideal");
        plot.addLegend(1, "1 sinusoid");
        for (int j = 2; j <= 10; ++j) {
            plot.addLegend(j, j + " sinusoids");
        }
        boolean first = true;
        plot.addPoint(0, 0.0, 0.0, false);
        for (int i = 0; i <= 400; ++i) {
            double approximation = 0.0;
            for (int j = 1; j <= 10; ++j) {
                double sig = 4.0 * Math.sin((double)i * 2.0 * Math.PI * (double)(2 * j - 1) / 400.0) / (Math.PI * (double)(2 * j - 1));
                plot.addPoint(j, i, approximation += sig, !first);
            }
            first = false;
            if (i <= 200) {
                plot.addPoint(0, i, 1.0, true);
            }
            if (i < 200) continue;
            plot.addPoint(0, i, -1.0, true);
        }
        plot.addPoint(0, 400.0, 0.0, true);
    }
}

