/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.freehep.graphicsbase.util.export.ExportDialog;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotFormatter;
import ptolemy.util.StringUtilities;

public class PlotFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    public PlotBox plot;
    protected JMenuBar _menubar = new JMenuBar();
    protected JMenu _editMenu = new JMenu("Edit");
    protected JMenu _fileMenu = new JMenu("File");
    protected JMenu _specialMenu = new JMenu("Special");
    protected File _directory = null;
    protected File _file = null;

    public PlotFrame() {
        this("Ptolemy Plot Frame");
    }

    public PlotFrame(String title) {
        this(title, (PlotBox)null);
    }

    public PlotFrame(String title, PlotBox plotArg) {
        super(title);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                PlotFrame.this._closeFrame();
            }
        });
        this.setBackground(Color.white);
        this.plot = plotArg == null ? new Plot() : plotArg;
        this.plot.setBackground(Color.white);
        this._fileMenu.setMnemonic(70);
        this._editMenu.setMnemonic(69);
        this._specialMenu.setMnemonic(83);
        JMenuItem[] fileMenuItems = new JMenuItem[]{new JMenuItem("Open", 79), new JMenuItem("Save", 83), new JMenuItem("SaveAs", 65), new JMenuItem("Export", 69), new JMenuItem("Print", 80), new JMenuItem("Close", 67)};
        fileMenuItems[0].setAccelerator(KeyStroke.getKeyStroke(79, 2));
        fileMenuItems[1].setAccelerator(KeyStroke.getKeyStroke(83, 2));
        fileMenuItems[4].setAccelerator(KeyStroke.getKeyStroke(80, 2));
        fileMenuItems[5].setAccelerator(KeyStroke.getKeyStroke(87, 2));
        FileMenuListener fml = new FileMenuListener();
        for (int i = 0; i < fileMenuItems.length; ++i) {
            fileMenuItems[i].setActionCommand(fileMenuItems[i].getText());
            fileMenuItems[i].addActionListener(fml);
            this._fileMenu.add(fileMenuItems[i]);
        }
        this._menubar.add(this._fileMenu);
        JMenuItem format = new JMenuItem("Format", 70);
        FormatListener formatListener = new FormatListener();
        format.addActionListener(formatListener);
        this._editMenu.add(format);
        this._menubar.add(this._editMenu);
        JMenuItem[] specialMenuItems = new JMenuItem[]{new JMenuItem("About", 65), new JMenuItem("Help", 72), new JMenuItem("Clear", 67), new JMenuItem("Fill", 70), new JMenuItem("Reset axes", 82), new JMenuItem("Sample plot", 83)};
        SpecialMenuListener sml = new SpecialMenuListener();
        for (int i = 0; i < specialMenuItems.length; ++i) {
            specialMenuItems[i].setActionCommand(specialMenuItems[i].getText());
            specialMenuItems[i].addActionListener(sml);
            this._specialMenu.add(specialMenuItems[i]);
        }
        this._menubar.add(this._specialMenu);
        this.setJMenuBar(this._menubar);
        this.getContentPane().add((Component)this.plot, "Center");
        this.setSize(600, 400);
    }

    public void samplePlot() {
        this._file = null;
        this._directory = null;
        this.plot.samplePlot();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this._editMenu.setBackground(this._menubar.getBackground());
        this._fileMenu.setBackground(this._menubar.getBackground());
        this._specialMenu.setBackground(this._menubar.getBackground());
    }

    protected void _about() {
        JOptionPane.showMessageDialog(this, "PlotFrame class\nBy: Edward A. Lee and Christopher Brooks\nVersion 5.6, Build: $Id: PlotFrame.java,v 1.83 2005/07/28 18:49:30 cxh Exp $\n\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n\nCopyright (c) 1997-2005, The Regents of the University of California.", "About Ptolemy Plot", 1);
    }

    protected void _editFormat() {
        PlotFormatter fmt = new PlotFormatter(this.plot);
        fmt.openModal();
    }

    protected void _export() {
        ExportDialog export = new ExportDialog();
        export.showExportDialog(this.plot.getCanvas(), "Export image as ...", this.plot.getCanvas(), "jhplot");
    }

    protected void _help() {
        JOptionPane.showMessageDialog(this, "PlotFrame is a plot in a top-level window.\n  File formats understood: Ptplot ASCII.\n  Left mouse button: Zooming.", "About Ptolemy Plot", 1);
    }

    protected void _open() {
        JFileChooser fileDialog = new JFileChooser();
        fileDialog.setDialogTitle("Select a plot file");
        fileDialog.addChoosableFileFilter(new PLTOrXMLFileFilter());
        if (this._directory != null) {
            fileDialog.setCurrentDirectory(this._directory);
        } else {
            String cwd = StringUtilities.getProperty("user.dir");
            if (cwd != null) {
                fileDialog.setCurrentDirectory(new File(cwd));
            }
        }
        int returnVal = fileDialog.showOpenDialog(this);
        if (returnVal == 0) {
            this._file = fileDialog.getSelectedFile();
            this.setTitle(this._file.getName());
            this._directory = fileDialog.getCurrentDirectory();
            try {
                this.plot.clear(true);
                this._read(new URL("file", null, this._directory.getAbsolutePath()), new FileInputStream(this._file));
                this.plot.repaint();
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this, "File not found:\n" + ex.toString(), "Ptolemy Plot Error", 2);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Error reading input:\n" + ex.toString(), "Ptolemy Plot Error", 2);
            }
        }
    }

    protected void _print() {
        this._export();
    }

    protected void _closeFrame() {
        this.setVisible(false);
        this.dispose();
        System.gc();
    }

    protected void _printCrossPlatform() {
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this.plot);
        if (job.printDialog(aset)) {
            try {
                job.print(aset);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Printing failed:\n" + ex.toString(), "Print Error", 2);
            }
        }
    }

    protected void _printNative() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this.plot);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Printing failed:\n" + ex.toString(), "Print Error", 2);
            }
        }
    }

    protected void _read(URL base, InputStream in) throws IOException {
        this.plot.read(in);
    }

    protected void _save() {
        if (this._file != null) {
            try {
                FileOutputStream fout = new FileOutputStream(this._file);
                this.plot.write(fout);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Error writing file:\n" + ex.toString(), "Ptolemy Plot Error", 2);
            }
        } else {
            this._saveAs();
        }
    }

    protected void _saveAs() {
        JFileChooser fileDialog = new JFileChooser();
        fileDialog.addChoosableFileFilter(new PLTOrXMLFileFilter());
        fileDialog.setDialogTitle("Save plot as...");
        if (this._directory != null) {
            fileDialog.setCurrentDirectory(this._directory);
        } else {
            String cwd = StringUtilities.getProperty("user.dir");
            if (cwd != null) {
                fileDialog.setCurrentDirectory(new File(cwd));
            }
        }
        fileDialog.setSelectedFile(new File(fileDialog.getCurrentDirectory(), "plot.xml"));
        int returnVal = fileDialog.showSaveDialog(this);
        if (returnVal == 0) {
            this._file = fileDialog.getSelectedFile();
            this.setTitle(this._file.getName());
            this._directory = fileDialog.getCurrentDirectory();
            this._save();
        }
    }

    class FileMenuListener
    implements ActionListener {
        FileMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem target = (JMenuItem)e.getSource();
            String actionCommand = target.getActionCommand();
            try {
                if (actionCommand.equals("Open")) {
                    PlotFrame.this._open();
                } else if (actionCommand.equals("Save")) {
                    PlotFrame.this._save();
                } else if (actionCommand.equals("SaveAs")) {
                    PlotFrame.this._saveAs();
                } else if (actionCommand.equals("Export")) {
                    PlotFrame.this._export();
                } else if (actionCommand.equals("Print")) {
                    PlotFrame.this._print();
                } else if (actionCommand.equals("Close")) {
                    PlotFrame.this._closeFrame();
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "File Menu Exception:\n" + exception.toString(), "Ptolemy Plot Error", 2);
            }
            PlotFrame.this.repaint();
        }
    }

    class FormatListener
    implements ActionListener {
        FormatListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                PlotFrame.this._editFormat();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Format Exception:\n" + exception.toString(), "Ptolemy Plot Error", 2);
            }
            PlotFrame.this.repaint();
        }
    }

    class SpecialMenuListener
    implements ActionListener {
        SpecialMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem target = (JMenuItem)e.getSource();
            String actionCommand = target.getActionCommand();
            try {
                if (actionCommand.equals("About")) {
                    PlotFrame.this._about();
                } else if (actionCommand.equals("Help")) {
                    PlotFrame.this._help();
                } else if (actionCommand.equals("Fill")) {
                    PlotFrame.this.plot.fillPlot();
                } else if (actionCommand.equals("Reset axes")) {
                    PlotFrame.this.plot.resetAxes();
                } else if (actionCommand.equals("Clear")) {
                    PlotFrame.this.plot.clear(false);
                    PlotFrame.this.plot.repaint();
                } else if (actionCommand.equals("Sample plot")) {
                    PlotFrame.this.plot.clear(true);
                    PlotFrame.this.samplePlot();
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Special Menu Exception:\n" + exception.toString(), "Ptolemy Plot Error", 2);
            }
            PlotFrame.this.repaint();
        }
    }

    class PLTOrXMLFileFilter
    extends FileFilter {
        PLTOrXMLFileFilter() {
        }

        @Override
        public boolean accept(File fileOrDirectory) {
            if (fileOrDirectory.isDirectory()) {
                return true;
            }
            String fileOrDirectoryName = fileOrDirectory.getName();
            int dotIndex = fileOrDirectoryName.lastIndexOf(46);
            if (dotIndex == -1) {
                return false;
            }
            String extension = fileOrDirectoryName.substring(dotIndex);
            if (extension != null) {
                return extension.equalsIgnoreCase(".plt") || extension.equalsIgnoreCase(".xml");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return ".plt and .xml files";
        }
    }

    class EPSFileFilter
    extends FileFilter {
        EPSFileFilter() {
        }

        @Override
        public boolean accept(File fileOrDirectory) {
            if (fileOrDirectory.isDirectory()) {
                return true;
            }
            String fileOrDirectoryName = fileOrDirectory.getName();
            int dotIndex = fileOrDirectoryName.lastIndexOf(46);
            if (dotIndex == -1) {
                return false;
            }
            String extension = fileOrDirectoryName.substring(dotIndex);
            if (extension != null) {
                return extension.equalsIgnoreCase(".eps");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "Encapsulated PostScript (.eps) files";
        }
    }
}

