/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.text;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.Collection;
import org.clapper.util.text.TextUtil;

public abstract class XStringBufBase
implements CharSequence,
Appendable {
    public static final char METACHAR_SEQUENCE_START = '\\';

    XStringBufBase() {
    }

    public abstract void getChars(int var1, int var2, char[] var3, int var4) throws IndexOutOfBoundsException;

    protected abstract Appendable getBufferAsAppendable();

    protected abstract CharSequence getBufferAsCharSequence();

    protected abstract CharSequence newBufferAsCharSequence();

    protected abstract void deleteCharacters(int var1, int var2) throws IndexOutOfBoundsException;

    protected abstract void insertCharacter(int var1, char var2);

    protected abstract void insertCharacters(int var1, char[] var2, int var3, int var4);

    protected abstract void replaceString(int var1, int var2, String var3) throws IndexOutOfBoundsException;

    public XStringBufBase append(boolean val) {
        try {
            this.getBufferAsAppendable().append(String.valueOf(val));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public XStringBufBase append(char c) {
        try {
            this.getBufferAsAppendable().append(c);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public XStringBufBase append(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            this.append(chars[i]);
        }
        return this;
    }

    public XStringBufBase append(char[] chars, int offset, int len) {
        Appendable buf = this.getBufferAsAppendable();
        while (offset < len) {
            try {
                buf.append(chars[offset++]);
            }
            catch (IOException iOException) {}
        }
        return this;
    }

    public XStringBufBase append(double val) {
        try {
            this.getBufferAsAppendable().append(String.valueOf(val));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public XStringBufBase append(float val) {
        try {
            this.getBufferAsAppendable().append(String.valueOf(val));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public XStringBufBase append(int val) {
        try {
            this.getBufferAsAppendable().append(String.valueOf(val));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public XStringBufBase append(long val) {
        try {
            this.getBufferAsAppendable().append(String.valueOf(val));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public XStringBufBase append(Object obj) {
        try {
            this.getBufferAsAppendable().append(obj.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public XStringBufBase append(short val) {
        try {
            this.getBufferAsAppendable().append(String.valueOf(val));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public XStringBufBase append(String s) {
        try {
            this.getBufferAsAppendable().append(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public XStringBufBase append(CharSequence csq) {
        try {
            this.getBufferAsAppendable().append(csq);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public XStringBufBase append(CharSequence csq, int start, int end) {
        try {
            this.getBufferAsAppendable().append(csq, start, end);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public char charAt(int index) throws IndexOutOfBoundsException {
        return this.getBufferAsCharSequence().charAt(index);
    }

    public boolean delete(String substring) {
        boolean deleted = false;
        int i = this.indexOf(substring);
        if (i > -1) {
            this.deleteCharacters(i, i + substring.length());
            deleted = true;
        }
        return deleted;
    }

    public void clear() {
        this.delete(0, this.length());
    }

    public XStringBufBase delete(int start, int end) throws IndexOutOfBoundsException {
        this.deleteCharacters(start, end);
        return this;
    }

    public void encodeMetacharacters(int start, int end) throws IndexOutOfBoundsException, IOException {
        char[] chars = this.toString().toCharArray();
        int i = 0;
        StringBuilder scratch = new StringBuilder();
        this.clear();
        try {
            while (i < start) {
                this.append(chars[i++]);
            }
            while (i < end) {
                this.append(XStringBufBase.encodeOneMetacharacter(chars[i++], scratch));
            }
            while (i < chars.length) {
                this.append(chars[i++]);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new StringIndexOutOfBoundsException(String.valueOf(i));
        }
    }

    public void encodeMetacharacters() {
        try {
            this.encodeMetacharacters(0, this.length());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void decodeMetacharacters(int start, int end) throws StringIndexOutOfBoundsException {
        char[] chars = this.toString().toCharArray();
        int i = 0;
        StringBuilder newBuf = new StringBuilder();
        try {
            int c;
            while (i < start) {
                newBuf.append(chars[i++]);
            }
            String region = new String(chars, i, end - i);
            StringReader sr = new StringReader(region);
            PushbackReader pb = new PushbackReader(sr, 5);
            while ((c = pb.read()) != -1) {
                if (c == 92) {
                    c = pb.read();
                    if (c == -1) {
                        newBuf.append((char)c);
                        continue;
                    }
                    if ((c = this.decodeMetacharacter(c, pb)) == -1) break;
                    if (c == -2) {
                        newBuf.append('\\');
                        continue;
                    }
                    newBuf.append((char)c);
                    continue;
                }
                newBuf.append((char)c);
            }
            i = end;
            while (i < chars.length) {
                newBuf.append(chars[i++]);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new StringIndexOutOfBoundsException(String.valueOf(i));
        }
        catch (IOException ex) {
            throw new StringIndexOutOfBoundsException();
        }
        this.clear();
        this.append(newBuf.toString());
    }

    public void decodeMetacharacters() {
        try {
            this.decodeMetacharacters(0, this.length());
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public int indexOf(int ch) {
        return this.toString().indexOf(ch);
    }

    public int indexOf(String str) {
        return this.toString().indexOf(str);
    }

    public int indexOf(String str, int start) {
        return this.toString().indexOf(str, start);
    }

    public XStringBufBase insert(int index, boolean val) {
        return this.insert(index, String.valueOf(val));
    }

    public XStringBufBase insert(int index, char ch) {
        this.insertCharacter(index, ch);
        return this;
    }

    public XStringBufBase insert(int index, char[] chars) {
        this.insertCharacters(index, chars, 0, chars.length);
        return this;
    }

    public XStringBufBase insert(int index, char[] chars, int offset, int len) {
        this.insertCharacters(index, chars, offset, len);
        return this;
    }

    public XStringBufBase insert(int index, double val) {
        return this.insert(index, String.valueOf(val));
    }

    public XStringBufBase insert(int index, float val) {
        return this.insert(index, String.valueOf(val));
    }

    public XStringBufBase insert(int index, int val) {
        return this.insert(index, String.valueOf(val));
    }

    public XStringBufBase insert(int index, long val) {
        return this.insert(index, String.valueOf(val));
    }

    public XStringBufBase insert(int index, short val) {
        return this.insert(index, String.valueOf(val));
    }

    public XStringBufBase insert(int index, Object obj) {
        return this.insert(index, obj.toString());
    }

    public XStringBufBase insert(int index, String s) {
        this.insertCharacters(index, s.toCharArray(), 0, s.length());
        return this;
    }

    @Override
    public int length() {
        return this.getBufferAsCharSequence().length();
    }

    public XStringBufBase replace(int start, int end, String str) throws StringIndexOutOfBoundsException {
        this.replaceString(start, end, str);
        return this;
    }

    public boolean replace(String substring, String replacement) {
        boolean replaced = false;
        int i = this.indexOf(substring);
        if (i > -1) {
            this.replaceString(i, i + substring.length(), replacement);
            replaced = true;
        }
        return replaced;
    }

    public boolean replace(String substring, char replacement) {
        boolean replaced = false;
        int i = this.indexOf(substring);
        if (i > -1) {
            this.deleteCharacters(i, i + substring.length());
            this.insert(i, replacement);
            replaced = true;
        }
        return replaced;
    }

    public int replaceAll(String substring, String replacement) {
        int i;
        StringBuilder buf = new StringBuilder(this.getBufferAsCharSequence());
        int total = 0;
        int start = 0;
        while (start < buf.length() && (i = buf.toString().indexOf(substring, start)) >= 0) {
            buf.replace(i, i + substring.length(), replacement);
            ++total;
            start = i + replacement.length();
        }
        this.clear();
        this.append(buf.toString());
        return total;
    }

    public int replaceAll(char ch, char replacement) {
        int len = this.length();
        char[] chars = new char[len];
        int total = 0;
        this.getChars(0, len, chars, 0);
        for (int i = 0; i < len; ++i) {
            if (chars[i] != ch) continue;
            chars[i] = replacement;
            ++total;
        }
        if (total > 0) {
            this.clear();
            this.append(chars);
        }
        return total;
    }

    public int replaceAll(char ch, String replacement) {
        return this.replaceAll("" + ch, replacement);
    }

    public void reset(String str) {
        this.clear();
        this.append(str);
    }

    public String[] split() {
        return TextUtil.split(this.toString());
    }

    public String[] split(char delim) {
        return TextUtil.split(this.toString(), delim);
    }

    public String[] split(String delimSet) {
        return TextUtil.split(this.toString(), delimSet);
    }

    public int split(char delim, Collection<String> collection) {
        return TextUtil.split(this.toString(), delim, collection);
    }

    public int split(String delimSet, Collection<String> collection) {
        return TextUtil.split(this.toString(), delimSet, collection);
    }

    public String substring(int index) throws StringIndexOutOfBoundsException {
        return this.substring(index, this.length());
    }

    public String substring(int start, int end) throws StringIndexOutOfBoundsException {
        return this.subSequence(start, end).toString();
    }

    @Override
    public CharSequence subSequence(int start, int end) throws IndexOutOfBoundsException {
        return this.getBufferAsCharSequence().subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.getBufferAsCharSequence().toString();
    }

    private static String encodeOneMetacharacter(char c, StringBuilder buf) {
        StringBuilder result = new StringBuilder();
        if (TextUtil.isPrintable(c)) {
            if (c == '\\') {
                result.append('\\');
                result.append('\\');
            } else {
                result.append(c);
            }
        } else {
            switch (c) {
                case '\r': {
                    result.append("\\r");
                    break;
                }
                case '\n': {
                    result.append("\\n");
                    break;
                }
                case '\t': {
                    result.append("\\t");
                    break;
                }
                case '\f': {
                    result.append("\\f");
                    break;
                }
                default: {
                    result.append(XStringBufBase.toUnicodeEscape(c, buf));
                }
            }
        }
        return result.toString();
    }

    private static String toUnicodeEscape(char c, StringBuilder buf) {
        buf.setLength(0);
        return TextUtil.charToUnicodeEscape(c, buf);
    }

    private int decodeMetacharacter(int c, PushbackReader pb) throws IOException {
        switch (c) {
            case 116: {
                c = 9;
                break;
            }
            case 110: {
                c = 10;
                break;
            }
            case 114: {
                c = 13;
                break;
            }
            case 92: {
                c = 92;
                break;
            }
            case 117: {
                c = this.decodeUnicodeSequence(pb);
                if (c != -2) break;
                pb.unread(117);
                c = 92;
                break;
            }
        }
        return c;
    }

    private int decodeUnicodeSequence(PushbackReader pb) throws IOException {
        int c = -1;
        boolean incomplete = false;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            c = pb.read();
            if (c == -1) {
                incomplete = true;
                break;
            }
            buf.append((char)c);
        }
        if (incomplete) {
            this.unread(buf.toString(), pb);
        } else {
            int code = 0;
            boolean error = false;
            try {
                code = Integer.parseInt(buf.toString(), 16);
                if (code < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException ex) {
                this.unread(buf.toString(), pb);
                error = true;
            }
            if (!Character.isDefined((char)code)) {
                this.unread(buf.toString(), pb);
                error = true;
            }
            c = (char)(error ? -2 : (char)code);
        }
        return c;
    }

    private void unread(String s, PushbackReader pb) throws IOException {
        for (int i = s.length() - 1; i >= 0; --i) {
            pb.unread(s.charAt(i));
        }
    }
}

