/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.text;

import org.clapper.util.text.AbstractVariableSubstituter;
import org.clapper.util.text.UndefinedVariableException;
import org.clapper.util.text.VariableDereferencer;
import org.clapper.util.text.VariableNameChecker;
import org.clapper.util.text.VariableSubstitutionException;
import org.clapper.util.text.VariableSyntaxException;

public class WindowsCmdVariableSubstituter
extends AbstractVariableSubstituter {
    @Override
    public String substitute(String s, VariableDereferencer deref, VariableNameChecker nameChecker, Object context) throws VariableSyntaxException, UndefinedVariableException, VariableSubstitutionException {
        if (s != null) {
            s = this.doSubstitution(s, context, nameChecker, deref);
        }
        return s;
    }

    private String doSubstitution(String s, Object context, VariableNameChecker nameChecker, VariableDereferencer deref) throws VariableSubstitutionException {
        StringBuffer result = new StringBuffer();
        int len = s.length();
        char prev = '\u0000';
        StringBuffer var = new StringBuffer();
        boolean inVar = false;
        boolean syntaxError = false;
        if (nameChecker == null) {
            nameChecker = this;
        }
        char[] ch = s.toCharArray();
        for (int i = 0; i < len; ++i) {
            char c = ch[i];
            if (c == '%') {
                if (inVar) {
                    if (prev == '%') {
                        inVar = false;
                        result.append('%');
                        continue;
                    }
                    String varName = var.toString();
                    if (syntaxError) {
                        result.append('%' + varName + '%');
                    } else {
                        String value = deref.getVariableValue(varName, context);
                        if ((value == null || value.length() == 0) && this.getAbortOnUndefinedVariable()) {
                            throw new UndefinedVariableException("Variable \"" + varName + "\" is not defined.");
                        }
                        result.append(value == null ? "" : value);
                    }
                    var.setLength(0);
                    inVar = false;
                    syntaxError = false;
                    prev = '\u0000';
                    continue;
                }
                inVar = true;
                prev = c;
                continue;
            }
            if (inVar) {
                var.append(c);
                if (!nameChecker.legalVariableCharacter(c)) {
                    syntaxError = true;
                }
            } else {
                result.append(c);
            }
            prev = c;
        }
        if (inVar) {
            result.append('%');
            result.append(var.toString());
            syntaxError = true;
        }
        if (syntaxError && this.getAbortOnSyntaxError()) {
            throw new VariableSyntaxException("Syntactically incorrect reference to variable \"" + var.toString() + "\"");
        }
        return result.toString();
    }
}

