/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public final class TextUtil {
    public static final char[] HEXADECIMAL_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final RomanNumberTableEntry[] ROMAN_NUMBER_TABLE = new RomanNumberTableEntry[]{new RomanNumberTableEntry("M", 1000), new RomanNumberTableEntry("CM", 900), new RomanNumberTableEntry("D", 500), new RomanNumberTableEntry("CD", 400), new RomanNumberTableEntry("C", 100), new RomanNumberTableEntry("XC", 90), new RomanNumberTableEntry("L", 50), new RomanNumberTableEntry("XL", 40), new RomanNumberTableEntry("X", 10), new RomanNumberTableEntry("IX", 9), new RomanNumberTableEntry("V", 5), new RomanNumberTableEntry("IV", 4), new RomanNumberTableEntry("I", 1)};

    private TextUtil() {
    }

    public static boolean booleanFromString(String s) throws IllegalArgumentException {
        boolean result;
        if ((s = s.toLowerCase()).equals("true") || s.equals("1") || s.equals("yes") || s.equals("y")) {
            result = true;
        } else if (s.equals("false") || s.equals("0") || s.equals("no") || s.equals("n")) {
            result = false;
        } else {
            throw new IllegalArgumentException("Bad boolean string: \"" + s + "\"");
        }
        return result;
    }

    public static String[] split(String s) {
        return TextUtil.split(s, (String)null);
    }

    public static String[] split(String s, boolean preserveEmptyFields) {
        return TextUtil.split(s, (String)null, preserveEmptyFields);
    }

    public static int split(String s, Collection<String> collection) {
        return TextUtil.split(s, collection, false);
    }

    public static int split(String s, Collection<String> collection, boolean preserveEmptyFields) {
        return TextUtil.split(s, null, collection, preserveEmptyFields);
    }

    public static String[] split(String s, char delim) {
        return TextUtil.split(s, "" + delim, false);
    }

    public static String[] split(String s, char delim, boolean preserveEmptyFields) {
        return TextUtil.split(s, String.valueOf(delim), preserveEmptyFields);
    }

    public static String[] split(String s, String delimSet) {
        return TextUtil.split(s, delimSet, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] split(String s, String delimSet, boolean preserveEmptyFields) {
        String[] result = null;
        ArrayList<String> temp = new ArrayList<String>();
        if (delimSet == null) {
            delimSet = " \t\n\r";
        }
        StringTokenizer tok = new StringTokenizer(s, delimSet, preserveEmptyFields);
        boolean lastWasDelim = true;
        while (true) {
            String token;
            block6: {
                if (!tok.hasMoreTokens()) {
                    result = new String[temp.size()];
                    temp.toArray(result);
                    return result;
                }
                token = tok.nextToken();
                if (preserveEmptyFields && token.length() == 1 && delimSet.indexOf(token.charAt(0)) != -1) {
                    if (lastWasDelim) {
                        token = "";
                        break block6;
                    } else {
                        lastWasDelim = true;
                        continue;
                    }
                }
                lastWasDelim = false;
            }
            temp.add(token);
        }
    }

    public static int split(String s, char delim, Collection<String> collection) {
        return TextUtil.split(s, String.valueOf(delim), collection);
    }

    public static int split(String s, char delim, Collection<String> collection, boolean preserveEmptyFields) {
        return TextUtil.split(s, String.valueOf(delim), collection, preserveEmptyFields);
    }

    public static int split(String s, String delimSet, Collection<String> collection) {
        return TextUtil.split(s, delimSet, collection, false);
    }

    public static int split(String s, String delimSet, Collection<String> collection, boolean preserveEmptyFields) {
        String[] strs = TextUtil.split(s, delimSet, preserveEmptyFields);
        for (int i = 0; i < strs.length; ++i) {
            collection.add(strs[i]);
        }
        return strs.length;
    }

    public static String join(String[] strings, String delim) {
        StringBuilder result = new StringBuilder();
        String sep = "";
        for (int i = 0; i < strings.length; ++i) {
            result.append(sep);
            result.append(strings[i]);
            sep = delim;
        }
        return result.toString();
    }

    public static String join(String delim, String ... strings) {
        return TextUtil.join(strings, delim);
    }

    public static String join(String[] strings, char delim) {
        return TextUtil.join(strings, "" + delim);
    }

    public static String join(String[] strings, int start, int end, char delim) {
        return TextUtil.join(strings, start, end, "" + delim);
    }

    public static String join(String[] strings, int start, int end, String delim) {
        StringBuilder result = new StringBuilder();
        String sep = "";
        while (start < end) {
            result.append(sep);
            result.append(strings[start]);
            sep = delim;
            ++start;
        }
        return result.toString();
    }

    public static String join(char delim, String ... strings) {
        return TextUtil.join(strings, "" + delim);
    }

    public static String join(Collection<? extends Object> objects, String delim) {
        String result = "";
        if (objects.size() > 0) {
            int i = 0;
            for (Object object : objects) {
                if (object == null) continue;
                ++i;
            }
            String[] array = new String[i];
            i = 0;
            for (Object object : objects) {
                if (object == null) continue;
                array[i++] = object.toString();
            }
            result = TextUtil.join(array, delim);
        }
        return result;
    }

    public static String join(Collection<? extends Object> objects, char delim) {
        return TextUtil.join(objects, "" + delim);
    }

    public static boolean stringIsEmpty(String s) {
        boolean isEmpty = true;
        if (s != null) {
            char[] chars = s.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (Character.isWhitespace(chars[i])) continue;
                isEmpty = false;
                break;
            }
        }
        return isEmpty;
    }

    public static String rightJustifyString(String s, int width) {
        return TextUtil.rightJustifyString(s, width, ' ');
    }

    public static String rightJustifyString(String s, int width, char c) {
        StringBuilder paddedString = new StringBuilder(width);
        int len = s.length();
        int paddingNeeded = width < len ? 0 : width - len;
        for (int i = 0; i < paddingNeeded; ++i) {
            paddedString.append(c);
        }
        paddedString.append(s);
        return paddedString.toString();
    }

    public static String leftJustifyString(String s, int width) {
        return TextUtil.leftJustifyString(s, width, ' ');
    }

    public static String leftJustifyString(String s, int width, char c) {
        StringBuilder paddedString = new StringBuilder(width);
        int len = s.length();
        int paddingNeeded = width < len ? 0 : width - len;
        paddedString.append(s);
        for (int i = 0; i < paddingNeeded; ++i) {
            paddedString.append(c);
        }
        return paddedString.toString();
    }

    public static String centerString(String s, int width) {
        return TextUtil.centerString(s, width, ' ');
    }

    public static String centerString(String s, int width, char c) {
        int i;
        StringBuilder paddedString = new StringBuilder(width);
        int len = s.length();
        int paddingNeeded = width < len ? 0 : width - len;
        int frontPadding = i = paddingNeeded / 2;
        int tailPadding = i + paddingNeeded % 2;
        for (i = 0; i < frontPadding; ++i) {
            paddedString.append(c);
        }
        paddedString.append(s);
        for (i = 0; i < tailPadding; ++i) {
            paddedString.append(c);
        }
        return paddedString.toString();
    }

    public static StringBuilder hexadecimalForByte(byte b, StringBuilder buf) {
        int nybble = b >>> 4 & 0xF;
        buf.append(HEXADECIMAL_DIGITS[nybble]);
        nybble = b & 0xF;
        buf.append(HEXADECIMAL_DIGITS[nybble]);
        return buf;
    }

    public static StringBuilder hexadecimalForByte(int b, StringBuilder buf) {
        int nybble = b >>> 4 & 0xF;
        buf.append(HEXADECIMAL_DIGITS[nybble]);
        nybble = b & 0xF;
        buf.append(HEXADECIMAL_DIGITS[nybble]);
        return buf;
    }

    public static StringBuilder hexadecimalForBytes(byte[] bytes, int start, int end, StringBuilder buf) {
        for (int i = start; i < end; ++i) {
            TextUtil.hexadecimalForByte(bytes[i], buf);
        }
        return buf;
    }

    public static String hexadecimalForBytes(byte[] bytes) {
        return TextUtil.hexadecimalForBytes(bytes, 0, bytes.length, new StringBuilder()).toString();
    }

    public static StringBuilder hexadecimalForBytes(int[] bytes, int start, int end, StringBuilder buf) {
        for (int i = start; i < end; ++i) {
            TextUtil.hexadecimalForByte(bytes[i], buf);
        }
        return buf;
    }

    public static StringBuilder hexadecimalForNumber(int num, StringBuilder buf) {
        return TextUtil.encodeNumber(num, HEXADECIMAL_DIGITS.length, HEXADECIMAL_DIGITS, buf);
    }

    public static String hexadecimalForNumber(int num) {
        return TextUtil.encodeNumber(num, HEXADECIMAL_DIGITS.length, HEXADECIMAL_DIGITS, new StringBuilder()).toString();
    }

    public static StringBuilder hexadecimalForNumber(long num, StringBuilder buf) {
        return TextUtil.encodeNumber(num, HEXADECIMAL_DIGITS.length, HEXADECIMAL_DIGITS, buf);
    }

    public static String hexadecimalForNumber(long num) {
        return TextUtil.encodeNumber(num, HEXADECIMAL_DIGITS.length, HEXADECIMAL_DIGITS, new StringBuilder()).toString();
    }

    public static String hexadecimalForNumber(short num) {
        return TextUtil.encodeNumber(num, HEXADECIMAL_DIGITS.length, HEXADECIMAL_DIGITS, new StringBuilder()).toString();
    }

    public static StringBuilder hexadecimalForNumber(short num, StringBuilder buf) {
        return TextUtil.encodeNumber(num, HEXADECIMAL_DIGITS.length, HEXADECIMAL_DIGITS, buf);
    }

    public static StringBuilder encodeNumber(long num, int base, char[] digits, StringBuilder buf) {
        char[] temp = new char[64];
        int i = 0;
        while (num != 0L) {
            int digit = (int)(num % (long)base);
            num /= (long)base;
            temp[i++] = digits[digit];
        }
        if (i == 0) {
            temp[i++] = digits[0];
        }
        while (--i >= 0) {
            buf.append(temp[i]);
        }
        return buf;
    }

    public static StringBuilder encodeNumber(short num, int base, char[] digits, StringBuilder buf) {
        char[] temp = new char[16];
        int i = 0;
        while (num != 0) {
            int digit = num % base;
            num = (short)(num / base);
            temp[i++] = digits[digit];
        }
        if (i == 0) {
            temp[i++] = digits[0];
        }
        while (--i >= 0) {
            buf.append(temp[i]);
        }
        return buf;
    }

    public static StringBuilder encodeNumber(int num, int base, char[] digits, StringBuilder buf) {
        char[] temp = new char[32];
        int i = 0;
        while (num != 0) {
            int digit = num % base;
            num /= base;
            temp[i++] = digits[digit];
        }
        if (i == 0) {
            temp[i++] = digits[0];
        }
        while (--i >= 0) {
            buf.append(temp[i]);
        }
        return buf;
    }

    public static byte[] bytesForHexadecimal(String hexString) throws NumberFormatException {
        byte[] result = null;
        StringBuilder stripped = new StringBuilder();
        StringTokenizer tok = new StringTokenizer(hexString);
        while (tok.hasMoreTokens()) {
            stripped.append(tok.nextToken());
        }
        int len = stripped.length();
        if (len % 2 != 0) {
            throw new NumberFormatException("Hex string \"" + hexString + "\" does not have an even number of hex digits.");
        }
        hexString = stripped.toString();
        result = new byte[len / 2];
        int i = 0;
        int j = 0;
        while (i < len) {
            String hexByte = hexString.substring(i, i + 2);
            result[j] = (byte)(Integer.parseInt(hexByte, 16) & 0xFF);
            i += 2;
            ++j;
        }
        return result;
    }

    public static String romanNumeralsForNumber(int n) {
        assert (n > 0);
        StringBuilder buf = new StringBuilder();
        for (RomanNumberTableEntry tableEntry : ROMAN_NUMBER_TABLE) {
            while (n >= tableEntry.quantity) {
                buf.append(tableEntry.romanString);
                n -= tableEntry.quantity;
            }
        }
        return buf.toString();
    }

    public static String charToUnicodeEscape(char c, StringBuilder buf) {
        String hex = Integer.toHexString(c);
        buf.append("\\u");
        for (int i = hex.length(); i < 4; ++i) {
            buf.append('0');
        }
        buf.append(hex);
        return buf.toString();
    }

    public static String charToUnicodeEscape(char c) {
        return TextUtil.charToUnicodeEscape(c, new StringBuilder());
    }

    public static boolean isPrintable(char c) {
        boolean isPrintable = false;
        StringBuilder result = new StringBuilder();
        Character.UnicodeBlock ublock = Character.UnicodeBlock.of(c);
        if (ublock == Character.UnicodeBlock.BASIC_LATIN || ublock == Character.UnicodeBlock.LATIN_1_SUPPLEMENT || ublock == Character.UnicodeBlock.LATIN_EXTENDED_A) {
            int type = Character.getType(c);
            switch (type) {
                case 1: 
                case 2: 
                case 9: 
                case 12: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    isPrintable = true;
                }
            }
        }
        return isPrintable;
    }

    private static class RomanNumberTableEntry {
        final String romanString;
        final int quantity;

        RomanNumberTableEntry(String s, int num) {
            this.romanString = s;
            this.quantity = num;
        }
    }
}

