/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc.test;

import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.clapper.util.cmdline.CommandLineException;
import org.clapper.util.cmdline.CommandLineUsageException;
import org.clapper.util.cmdline.CommandLineUtility;
import org.clapper.util.cmdline.UsageInfo;
import org.clapper.util.misc.NestedException;

public class TestNestedException
extends CommandLineUtility {
    private String language = null;
    private String country = null;
    private static Locale locale = null;

    public static void main(String[] args) {
        TestNestedException tester = new TestNestedException();
        try {
            tester.execute(args);
        }
        catch (CommandLineUsageException ex) {
            System.exit(1);
        }
        catch (Exception ex) {
            if (ex instanceof NestedException) {
                NestedException nex = (NestedException)ex;
                System.err.println(nex.getMessages(false, locale));
                nex.printStackTrace(System.err, locale);
            } else {
                System.err.println(ex.getMessage());
                ex.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    private TestNestedException() {
    }

    protected void processPostOptionCommandLine(Iterator it) throws CommandLineUsageException, NoSuchElementException {
        this.language = (String)it.next();
        this.country = (String)it.next();
    }

    @Override
    protected void getCustomUsageInfo(UsageInfo info) {
        info.addParameter("<language>", "Locale language to use for errors.", true);
        info.addParameter("<country>", "Locale country code.", true);
    }

    @Override
    protected void runCommand() throws CommandLineException {
        locale = new Locale(this.language, this.country);
        try {
            this.foo();
        }
        catch (Exception ex) {
            throw new CommandLineException("org.clapper.util.misc.test.Test", "error", "Error (default)", ex);
        }
    }

    private void foo() throws CommandLineException {
        try {
            throw new IOException("Oops.");
        }
        catch (IOException ex) {
            throw new CommandLineException("org.clapper.util.misc.test.Test", "pageNotFound", "default message", ex);
        }
    }
}

