/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.clapper.util.cmdline.CommandLineException;
import org.clapper.util.cmdline.CommandLineUsageException;
import org.clapper.util.cmdline.CommandLineUtility;
import org.clapper.util.cmdline.UsageInfo;
import org.clapper.util.misc.LRUMap;
import org.clapper.util.misc.ObjectRemovalEvent;
import org.clapper.util.misc.ObjectRemovalListener;
import org.clapper.util.text.TextUtil;

public class TestLRUMap
extends CommandLineUtility
implements ObjectRemovalListener {
    private int initialCapacity = 16;
    private int maxCapacity = this.initialCapacity * 2;
    private float loadFactor = 0.75f;
    private Collection<String[]> keyValuePairs = new ArrayList<String[]>();

    public static void main(String[] args) {
        TestLRUMap tester = new TestLRUMap();
        try {
            tester.execute(args);
        }
        catch (CommandLineUsageException ex) {
            System.exit(1);
        }
        catch (CommandLineException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            System.exit(1);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private TestLRUMap() {
    }

    @Override
    public void objectRemoved(ObjectRemovalEvent event) {
        Map.Entry entry = (Map.Entry)event.getSource();
        System.out.println("*** Removal of " + entry.getKey().toString() + "=" + entry.getValue().toString());
    }

    @Override
    protected void runCommand() throws CommandLineException {
        LRUMap<String, String> map = new LRUMap<String, String>(this.initialCapacity, this.loadFactor, this.maxCapacity);
        map.addRemovalListener(this, false);
        for (String[] pair : this.keyValuePairs) {
            System.out.println("Adding: " + pair[0] + "=" + pair[1]);
            map.put(pair[0], pair[1]);
        }
        this.traverse(map);
        int newCapacity = this.maxCapacity / 2;
        System.out.println("Halving size of map to " + newCapacity);
        map.setMaximumCapacity(newCapacity);
        this.traverse(map);
    }

    @Override
    protected void parseCustomOption(char shortOption, String longOption, Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
        switch (shortOption) {
            case 'i': {
                this.initialCapacity = this.parseIntOptionArgument(shortOption, longOption, it.next(), 1, Integer.MAX_VALUE);
                break;
            }
            case 'm': {
                this.maxCapacity = this.parseIntOptionArgument(shortOption, longOption, it.next(), 1, Integer.MAX_VALUE);
                break;
            }
            case 'l': {
                this.loadFactor = this.parseFloatOptionArgument(shortOption, longOption, it.next(), 0.1f, 1.0f);
                break;
            }
            default: {
                throw new CommandLineUsageException("Unrecognized option");
            }
        }
    }

    @Override
    protected void processPostOptionCommandLine(Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
        do {
            String s;
            String[] fields;
            if ((fields = TextUtil.split(s = it.next(), "=")).length != 2) {
                throw new CommandLineUsageException("Bad key=value pair: \"" + s + "\"");
            }
            this.keyValuePairs.add(fields);
        } while (it.hasNext());
    }

    @Override
    protected void getCustomUsageInfo(UsageInfo info) {
        info.addOption('i', null, "<n>", "Set the initial capacity of the map to <n>.");
        info.addOption('m', null, "<n>", "Set the maximum capacity of the map to <n>.");
        info.addOption('l', null, "<f>", "Set the load capacity of the map to <f> (a floating point number)");
        info.addParameter("key=value ...", "One or more key=value pairs to put in the map.", true);
    }

    private void traverse(Map<String, String> map) {
        String value;
        System.out.println();
        System.out.println("Traversal by keySet() and get().");
        for (String key : map.keySet()) {
            value = map.get(key);
            if (value != null) {
                System.out.println(key.toString() + "=" + value.toString());
                continue;
            }
            System.out.println(key.toString() + "=null");
        }
        System.out.println();
        System.out.println("Traversal by keySet() and get().");
        for (String key : map.keySet()) {
            value = map.get(key);
            if (value != null) {
                System.out.println(key.toString() + "=" + value.toString());
                continue;
            }
            System.out.println(key.toString() + "=null");
        }
        System.out.println();
        System.out.println("Traversal by entry set.");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            System.out.println(entry.getKey() + "=" + entry.getValue());
        }
    }
}

