/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.util.ArrayList;
import java.util.Collection;

public class SparseArrayList<T>
extends ArrayList<T> {
    public SparseArrayList() {
    }

    public SparseArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public SparseArrayList(Collection<T> c) {
        super(c);
    }

    @Override
    public void add(int index, T element) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index " + index + " is negative.");
        }
        if (index >= this.size()) {
            this.set(index, element);
        } else {
            super.add(index, element);
        }
    }

    @Override
    public T set(int index, T element) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index " + index + " is negative.");
        }
        int curSize = this.size();
        if (index >= curSize) {
            int newSize = index + 1;
            this.ensureCapacity(newSize);
            while (curSize++ < newSize) {
                super.add(null);
            }
        }
        return super.set(index, element);
    }
}

