/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class BundleUtil {
    private BundleUtil() {
    }

    public static String getString(String bundleName, String key) {
        return BundleUtil.getMessage(bundleName, null, key, (String)null);
    }

    public static String getString(String bundleName, String key, String defaultMsg) {
        return BundleUtil.getMessage(bundleName, null, key, defaultMsg);
    }

    public static String getMessage(String bundleName, Locale locale, String key, String defaultMsg) {
        return BundleUtil.getMessage(bundleName, locale, key, defaultMsg, null);
    }

    public static String getMessage(String bundleName, String key, Object[] params) {
        return BundleUtil.getMessage(bundleName, Locale.getDefault(), key, params);
    }

    public static String getMessage(String bundleName, Locale locale, String key, String defaultMsg, Object[] params) {
        ResourceBundle bundle;
        String result = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((bundle = ResourceBundle.getBundle(bundleName, locale)) != null) {
            String fmt = null;
            try {
                fmt = bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (fmt == null) {
                fmt = defaultMsg;
            }
            if (fmt != null) {
                result = MessageFormat.format(fmt, params);
            }
        }
        if (result == null) {
            result = defaultMsg;
        }
        return result;
    }

    public static String getMessage(String bundleName, Locale locale, String key, Object[] params) {
        ResourceBundle bundle;
        String result = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((bundle = ResourceBundle.getBundle(bundleName, locale)) != null) {
            try {
                String fmt = bundle.getString(key);
                if (fmt != null) {
                    result = MessageFormat.format(fmt, params);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return result;
    }
}

