/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.clapper.util.io.FileFilterMatchType;

public class RegexFileFilter
implements FileFilter {
    private FileFilterMatchType matchType = FileFilterMatchType.PATH;
    private Pattern pattern;

    public RegexFileFilter(String regex, FileFilterMatchType matchType) throws PatternSyntaxException {
        this.matchType = matchType;
        this.pattern = Pattern.compile(regex);
    }

    public RegexFileFilter(String regex, int regexFlags, FileFilterMatchType matchType) throws PatternSyntaxException {
        this.matchType = matchType;
        this.pattern = Pattern.compile(regex, regexFlags);
    }

    @Override
    public boolean accept(File file) {
        String name = null;
        switch (this.matchType) {
            case PATH: {
                name = file.getPath();
                break;
            }
            case FILENAME: {
                name = file.getName();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return this.pattern.matcher(name).find();
    }
}

