/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public class FileUtil {
    private FileUtil() {
    }

    public static boolean isAbsolutePath(String path) throws IOException {
        boolean isAbsolute = false;
        String fileSep = System.getProperty("file.separator");
        if (fileSep.equals("/")) {
            isAbsolute = path.startsWith("/");
        } else if (fileSep.equals("\\")) {
            isAbsolute = Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' && path.charAt(2) == '\\';
        } else {
            throw new IOException("Can't determine operating system from file separator \"" + fileSep + "\"");
        }
        return isAbsolute;
    }

    public static int copyStream(InputStream is, OutputStream os) throws IOException {
        return FileUtil.copyStream(is, os, -1);
    }

    public static int copyStream(InputStream src, OutputStream dst, int bufferSize) throws IOException {
        int b;
        int totalCopied = 0;
        if (!(src instanceof BufferedInputStream)) {
            src = bufferSize > 0 ? new BufferedInputStream(src, bufferSize) : new BufferedInputStream(src);
        }
        if (!(dst instanceof BufferedOutputStream)) {
            dst = bufferSize > 0 ? new BufferedOutputStream(dst, bufferSize) : new BufferedOutputStream(dst);
        }
        while ((b = src.read()) != -1) {
            dst.write(b);
            ++totalCopied;
        }
        dst.flush();
        return totalCopied;
    }

    public static int copyReader(Reader reader, Writer writer, int bufferSize) throws IOException {
        int ch;
        if (!(reader instanceof BufferedReader)) {
            reader = bufferSize > 0 ? new BufferedReader(reader, bufferSize) : new BufferedReader(reader);
        }
        if (!(writer instanceof BufferedWriter)) {
            writer = bufferSize > 0 ? new BufferedWriter(writer, bufferSize) : new BufferedWriter(writer);
        }
        int total = 0;
        while ((ch = reader.read()) != -1) {
            writer.write(ch);
            ++total;
        }
        writer.flush();
        return total;
    }

    public static int copyReader(Reader reader, Writer writer) throws IOException {
        return FileUtil.copyReader(reader, writer, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyFile(File src, File dst) throws IOException {
        int totalCopied = 0;
        if (dst.isDirectory()) {
            dst = new File(dst, src.getName());
        }
        FileInputStream from = null;
        OutputStream to = null;
        try {
            from = new FileInputStream(src);
            to = new FileOutputStream(dst);
            totalCopied = FileUtil.copyStream(from, to);
        }
        finally {
            if (from != null) {
                ((InputStream)from).close();
            }
            if (to != null) {
                to.close();
            }
        }
        return totalCopied;
    }

    public static int copyTextFile(File src, String srcEncoding, File dst, String dstEncoding) throws IOException {
        if (dst.isDirectory()) {
            dst = new File(dst, src.getName());
        }
        InputStreamReader reader = srcEncoding != null ? new InputStreamReader((InputStream)new FileInputStream(src), srcEncoding) : new FileReader(src);
        OutputStreamWriter writer = dstEncoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(dst), dstEncoding) : new FileWriter(dst);
        int total = FileUtil.copyReader(reader, writer);
        ((Reader)reader).close();
        ((Writer)writer).close();
        return total;
    }

    public static String getDefaultEncoding() {
        return Charset.defaultCharset().name();
    }

    public static String getFileNameExtension(File file) {
        return FileUtil.getFileNameExtension(file.getName());
    }

    public static String getFileNameExtension(String path) {
        String ext = null;
        int i = path.lastIndexOf(46);
        if (i != -1 && i != path.length() - 1) {
            ext = path.substring(i + 1);
        }
        return ext;
    }

    public static String getFileNameNoExtension(File file) {
        return FileUtil.getFileNameNoExtension(file.getAbsolutePath());
    }

    public static String getFileNameNoExtension(String path) {
        int i = path.lastIndexOf(46);
        if (i != -1) {
            path = path.substring(0, i);
        }
        return path;
    }

    public static String dirname(String fileName) {
        return FileUtil.dirname(new File(fileName));
    }

    public static String dirname(File file) {
        String absName = file.getAbsolutePath();
        String fileSep = System.getProperty("file.separator");
        int lastSep = absName.lastIndexOf(fileSep);
        return absName.substring(0, lastSep);
    }

    public static String basename(String fileName) {
        String fileSep = System.getProperty("file.separator");
        int lastSep = fileName.lastIndexOf(fileSep);
        return lastSep == -1 ? fileName : fileName.substring(lastSep + 1);
    }

    public static String basename(File file) {
        return FileUtil.basename(file.getName());
    }
}

