/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class AndFileFilter
implements FileFilter {
    private List<FileFilter> filters = new LinkedList<FileFilter>();

    public AndFileFilter() {
    }

    public AndFileFilter(FileFilter ... filters) {
        for (FileFilter filter : filters) {
            this.addFilter(filter);
        }
    }

    public AndFileFilter addFilter(FileFilter filter) {
        this.filters.add(filter);
        return this;
    }

    public void removeFilter(FileFilter filter) {
        this.filters.remove(filter);
    }

    @Override
    public boolean accept(File file) {
        FileFilter filter;
        boolean accepted = true;
        Iterator<FileFilter> iterator = this.filters.iterator();
        while (iterator.hasNext() && (accepted = (filter = iterator.next()).accept(file))) {
        }
        return accepted;
    }
}

