/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.clapper.util.config.ConfigurationException;
import org.clapper.util.config.Variable;
import org.clapper.util.text.XStringBuilder;

class Section {
    private String name;
    private List<String> variableNames = new ArrayList<String>();
    private Map<String, Variable> valueMap = new HashMap<String, Variable>();
    private int id = 0;

    Section(String name, int id) {
        this.name = name;
        this.id = id;
    }

    int getID() {
        return this.id;
    }

    String getName() {
        return this.name;
    }

    Collection<String> getVariableNames() {
        return Collections.unmodifiableList(this.variableNames);
    }

    Variable getVariable(String varName) throws ConfigurationException {
        return this.valueMap.get(varName);
    }

    Variable addVariable(String varName, String value) {
        Variable variable = new Variable(varName, value, this);
        this.valueMap.put(varName, variable);
        this.variableNames.add(varName);
        return variable;
    }

    Variable addVariable(String varName, String value, int lineDefined) {
        Variable variable = this.addVariable(varName, value);
        variable.setLineWhereDefined(lineDefined);
        return variable;
    }

    void addVariables(Map<String, String> map) {
        for (String varName : map.keySet()) {
            String value = map.get(varName);
            this.addVariable(varName, value);
        }
    }

    protected Map<String, String> escapeEmbeddedBackslashes(Map<String, String> map) {
        XStringBuilder buf = new XStringBuilder();
        for (String varName : map.keySet()) {
            String varValue = map.get(varName);
            if (varValue.indexOf(92) == -1) continue;
            buf.clear();
            buf.append(varValue);
            buf.replaceAll("\\", "\\\\\\\\");
            map.put(varName, buf.toString());
        }
        return map;
    }
}

