/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.cmdline;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.clapper.util.cmdline.CommandLineUsageException;
import org.clapper.util.cmdline.OptionInfo;
import org.clapper.util.cmdline.ParameterHandler;
import org.clapper.util.cmdline.UsageInfo;
import org.clapper.util.io.WordWrapWriter;
import org.clapper.util.misc.ArrayIterator;
import org.clapper.util.misc.BundleUtil;
import org.clapper.util.text.TextUtil;

public final class ParameterParser {
    private static final int MAX_OPTION_STRING_LENGTH = 35;
    private UsageInfo usageInfo = null;

    public ParameterParser(UsageInfo usageInfo) {
        this.usageInfo = usageInfo;
    }

    public void parse(String[] params, ParameterHandler paramHandler) throws CommandLineUsageException {
        ArrayIterator<String> it = new ArrayIterator<String>(params);
        try {
            while (it.hasNext()) {
                String arg = it.next();
                if (arg.charAt(0) != '-') {
                    it.previous();
                    break;
                }
                OptionInfo optionInfo = null;
                if (arg.length() == 2) {
                    optionInfo = this.usageInfo.getOptionInfo(arg.charAt(1));
                } else {
                    if (!arg.startsWith("--")) {
                        throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.badLongOption", "Option \"{0}\" is not a single-character short option, but it does not start with \"{1}\", as long options must.", new Object[]{arg, "--"});
                    }
                    optionInfo = this.usageInfo.getOptionInfo(arg.substring(2));
                }
                if (optionInfo == null) {
                    throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.unknownOption", "Unknown option: \"{0}\"", new Object[]{arg});
                }
                paramHandler.parseOption(optionInfo.shortOption, optionInfo.longOption, it);
            }
            paramHandler.parsePostOptionParameters(it);
            if (it.hasNext()) {
                throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.tooManyParams", "Too many parameters.");
            }
        }
        catch (NoSuchElementException ex) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.missingParams", "Missing command line parameter(s).");
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new CommandLineUsageException("org.clapper.util.cmdline.Bundle", "CommandLineUtility.missingParams", "Missing command line parameter(s).");
        }
    }

    public String getUsageMessage(String prefixMsg) {
        return this.getUsageMessage(prefixMsg, 0);
    }

    public String getUsageMessage(String prefixMsg, int maxLineLength) {
        String sep;
        OptionInfo opt;
        String s;
        int i;
        String commandName;
        StringWriter buf = new StringWriter();
        int maxParamLength = 0;
        int maxOptionLength = 0;
        StringBuffer usageLine = new StringBuffer();
        Locale locale = Locale.getDefault();
        if (maxLineLength <= 0) {
            maxLineLength = Integer.MAX_VALUE;
        }
        WordWrapWriter out = new WordWrapWriter((Writer)buf, maxLineLength);
        if (prefixMsg != null) {
            out.println();
            out.println(prefixMsg);
            out.println();
        }
        if ((commandName = this.usageInfo.getCommandName()) != null) {
            usageLine.append(commandName);
        } else {
            usageLine.append("java ");
            usageLine.append(this.getClass().getName());
        }
        usageLine.append(' ');
        usageLine.append(BundleUtil.getMessage("org.clapper.util.cmdline.Bundle", locale, "CommandLineUtility.options1", "[options]"));
        usageLine.append(' ');
        String[] strings = this.usageInfo.getParameterNames();
        if (strings.length > 0) {
            for (i = 0; i < strings.length; ++i) {
                usageLine.append(' ');
                boolean optional = true;
                if (this.usageInfo.parameterIsRequired(strings[i])) {
                    optional = false;
                }
                if (optional) {
                    usageLine.append('[');
                }
                usageLine.append(strings[i]);
                if (optional) {
                    usageLine.append(']');
                }
                maxParamLength = Math.max(maxParamLength, strings[i].length() + 1);
            }
        }
        if ((s = this.usageInfo.getUsagePrologue()) != null) {
            out.println(s);
        }
        s = BundleUtil.getMessage("org.clapper.util.cmdline.Bundle", locale, "CommandLineUtility.usage", "Usage:");
        out.setPrefix(s + " ");
        out.println(usageLine.toString());
        out.setPrefix(null);
        out.println();
        out.println(BundleUtil.getMessage("org.clapper.util.cmdline.Bundle", locale, "CommandLineUtility.options2", "OPTIONS:"));
        out.println();
        maxOptionLength = 2;
        OptionInfo[] options = this.usageInfo.getOptions();
        for (i = 0; i < options.length; ++i) {
            opt = options[i];
            if (opt.explanation == null || opt.longOption == null) continue;
            int len = 0;
            sep = "";
            if (opt.shortOption != '\u0000') {
                len = 2;
                sep = ", ";
            }
            if (opt.longOption != null) {
                len += sep.length() + "--".length() + opt.longOption.length();
            }
            if (opt.argToken != null) {
                len += opt.argToken.length() + 1;
            }
            maxOptionLength = Math.max(maxOptionLength, len + 1);
        }
        if (maxOptionLength > 35) {
            maxOptionLength = 35;
        }
        StringBuffer optString = new StringBuffer();
        for (i = 0; i < options.length; ++i) {
            opt = options[i];
            if (opt.explanation == null) continue;
            optString.setLength(0);
            sep = "";
            if (opt.shortOption != '\u0000') {
                optString.append('-');
                optString.append(opt.shortOption);
                sep = ", ";
            }
            if (opt.longOption != null) {
                optString.append(sep);
                optString.append("--");
                optString.append(opt.longOption);
            }
            if (opt.argToken != null) {
                optString.append(' ');
                optString.append(opt.argToken);
            }
            if ((s = optString.toString()).length() > maxOptionLength) {
                out.println(s);
                out.setPrefix(this.padString(" ", maxOptionLength));
            } else {
                out.setPrefix(this.padString(optString.toString(), maxOptionLength));
            }
            out.println(opt.explanation);
            out.setPrefix(null);
        }
        strings = this.usageInfo.getParameterNames();
        if (strings.length > 0) {
            out.println();
            out.println(BundleUtil.getMessage("org.clapper.util.cmdline.Bundle", locale, "CommandLineUtility.params", "PARAMETERS:"));
            out.println();
            for (i = 0; i < strings.length; ++i) {
                out.setPrefix(this.padString(strings[i], maxParamLength));
                out.println(this.usageInfo.getParameterExplanation(strings[i]));
                out.setPrefix(null);
            }
        }
        if ((s = this.usageInfo.getUsageTrailer()) != null) {
            out.println();
            out.println(s);
        }
        out.flush();
        return buf.toString();
    }

    private String padString(String s, int toLength) {
        return TextUtil.leftJustifyString(s, toLength);
    }
}

