/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.colorchooser;

import java.awt.Color;

abstract class NamedColor
extends Color
implements Comparable {
    private static final long serialVersionUID = 1L;

    protected NamedColor(String name, int r, int g, int b) {
        super(r, g, b);
    }

    public abstract String getDisplayName();

    public abstract String getName();

    public String getInstantiationCode() {
        return this.toString();
    }

    static NamedColor create(Color c, String name) {
        return new DefaultNamedColor(c, name);
    }

    private static final class DefaultNamedColor
    extends NamedColor {
        private static final long serialVersionUID = 1L;
        private final String name;

        public DefaultNamedColor(Color c, String name) {
            super(name, c.getRed(), c.getGreen(), c.getBlue());
            this.name = name;
        }

        @Override
        public String getDisplayName() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public int compareTo(Object o) {
            if (o instanceof NamedColor) {
                NamedColor nc = (NamedColor)o;
                String nm = nc.getDisplayName();
                if (nm == null && this.getDisplayName() == null) {
                    return 0;
                }
                return nm != null && this.getDisplayName() != null ? this.getDisplayName().compareTo(nm) : -1;
            }
            return -1;
        }
    }
}

