/*
 * Decompiled with CFR 0.152.
 */
package jhplot.utils;

import java.awt.Color;
import java.util.ArrayList;
import jhplot.P0I;
import jhplot.PNI;

public class ColorPixel {
    public static Color getColor(int c) {
        int r = (c & 0xFF0000) >> 16;
        int g = (c & 0xFF00) >> 8;
        int b = c & 0xFF;
        return new Color(r, g, b);
    }

    public static int[] getRGB(int c) {
        int[] tmp = new int[]{(c & 0xFF0000) >> 16, (c & 0xFF00) >> 8, c & 0xFF};
        return tmp;
    }

    public static ArrayList<int[]> getRGB(int[] c) {
        int[] r = new int[3];
        int[] g = new int[3];
        int[] b = new int[3];
        for (int i = 0; i < c.length; ++i) {
            r[i] = (c[i] & 0xFF0000) >> 16;
            g[i] = (c[i] & 0xFF00) >> 8;
            b[i] = c[i] & 0xFF;
        }
        ArrayList<int[]> tt = new ArrayList<int[]>();
        tt.add(r);
        tt.add(g);
        tt.add(b);
        return tt;
    }

    public static ArrayList<P0I> getP0I(int[] c) {
        P0I r = new P0I("red");
        P0I g = new P0I("green");
        P0I b = new P0I("blue");
        for (int i = 0; i < c.length; ++i) {
            int rr = (c[i] & 0xFF0000) >> 16;
            int gg = (c[i] & 0xFF00) >> 8;
            int bb = c[i] & 0xFF;
            r.add(rr);
            g.add(gg);
            b.add(bb);
        }
        ArrayList<P0I> tt = new ArrayList<P0I>();
        tt.add(r);
        tt.add(g);
        tt.add(b);
        return tt;
    }

    public static PNI getPNI(int[] c) {
        PNI r = new PNI("colors");
        for (int i = 0; i < c.length; ++i) {
            int[] tmp = new int[]{(c[i] & 0xFF0000) >> 16, (c[i] & 0xFF00) >> 8, c[i] & 0xFF};
            r.add(tmp);
        }
        return r;
    }

    public static int getPixel(Color c) {
        int red = c.getRed();
        int green = c.getGreen();
        int blue = c.getBlue();
        int pix = ((red & 0xFF) << 16) + ((green & 0xFF) << 8) + (blue & 0xFF);
        return pix;
    }

    public static int getPixel(int red, int green, int blue) {
        int pix = ((red & 0xFF) << 16) + ((green & 0xFF) << 8) + (blue & 0xFF);
        return pix;
    }

    public static int[] getPixel(int[] red, int[] green, int[] blue) {
        int[] tmp = new int[red.length];
        for (int i = 0; i < red.length; ++i) {
            int r = red[i];
            int g = green[i];
            int b = blue[i];
            tmp[i] = ((r & 0xFF) << 16) + ((g & 0xFF) << 8) + (b & 0xFF);
        }
        return tmp;
    }
}

