/*
 * Decompiled with CFR 0.152.
 */
package com.flaptor.hist4j;

import com.flaptor.hist4j.Cell;
import com.flaptor.hist4j.HistogramDataNode;
import com.flaptor.hist4j.HistogramNode;
import java.io.Serializable;
import java.util.ArrayList;

public class AdaptiveHistogram
implements Serializable {
    private static final long serialVersionUID = -1L;
    private long totalCount;
    private HistogramNode root = null;

    public AdaptiveHistogram() {
        this.reset();
    }

    public void reset() {
        if (null != this.root) {
            this.root.reset();
            this.root = null;
        }
        this.totalCount = 0L;
    }

    public synchronized void addValue(float value) {
        ++this.totalCount;
        if (null == this.root) {
            this.root = new HistogramDataNode();
        }
        this.root = this.root.addValue(this, value);
    }

    public long getCount(float value) {
        long count = 0L;
        if (null != this.root) {
            count = this.root.getCount(value);
        }
        return count;
    }

    public long getAccumCount(float value) {
        long count = 0L;
        if (null != this.root) {
            count = this.root.getAccumCount(value);
        }
        return count;
    }

    public float getValueForPercentile(int percentile) {
        long targetAccumCount = this.totalCount * (long)percentile / 100L;
        Float value = new Float(0.0f);
        if (null != this.root) {
            value = this.root.getValueForAccumCount(new long[]{0L, targetAccumCount});
        }
        return null != value ? value.floatValue() : 0.0f;
    }

    protected int getCountPerNodeLimit() {
        int limit = (int)(this.totalCount / 10L);
        if (0 == limit) {
            limit = 1;
        }
        return limit;
    }

    public void normalize(float targetMin, float targetMax) {
        if (null != this.root) {
            final float min = this.getValueForPercentile(0);
            float max = this.getValueForPercentile(100);
            final float m = (targetMax - targetMin) * (max > min ? 1.0f / (max - min) : 1.0f);
            final float b = targetMin;
            this.root.apply(new ValueConversion(){

                @Override
                public float convertValue(float value) {
                    return m * (value - min) + b;
                }
            });
        }
    }

    public void show() {
        System.out.println("Histogram has " + this.totalCount + " values:");
        if (null != this.root) {
            this.root.show(0);
        }
    }

    public ArrayList<Cell> toTable() {
        ArrayList<Cell> table = new ArrayList<Cell>();
        if (null != this.root) {
            this.root.toTable(table);
        }
        return table;
    }

    protected static interface ValueConversion {
        public float convertValue(float var1);
    }
}

