/*
 * Decompiled with CFR 0.152.
 */
package com.csam.dif;

import com.csam.dif.DIFCell;
import com.csam.dif.DIFDataException;
import com.csam.dif.DIFKeywords;
import com.csam.dif.DIFRow;
import com.csam.dif.DIFSheet;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Iterator;

public class DIFWriter {
    private SimpleDateFormat usFmt = new SimpleDateFormat("MM/dd/yyyy");

    public static void writeSheet(DIFSheet sheet, OutputStream outStream) {
        DIFWriter writer = new DIFWriter();
        writer.write(sheet, outStream);
    }

    public void write(DIFSheet sheet, OutputStream outStream) {
        PrintWriter writer = new PrintWriter(outStream);
        this.writeTitle(writer, sheet);
        int vectors = this.writeVectors(writer, sheet);
        int tuples = this.writeTuples(writer, sheet);
        this.writeData(writer);
        for (int i = 0; i < tuples; ++i) {
            writer.println("-1,0");
            writer.println(DIFKeywords.BOT.name());
            if (!sheet.hasRow(i)) {
                int j = 0;
                while (j < vectors) {
                    writer.println("1,0");
                    this.writeString(writer, "");
                    ++i;
                }
                continue;
            }
            DIFRow row = sheet.getRow(i);
            for (int j = 0; j < vectors; ++j) {
                if (!row.hasCell(j)) {
                    writer.println("1,0");
                    this.writeString(writer, "");
                    continue;
                }
                DIFCell cell = row.getCell(j);
                try {
                    if (cell.getCellType().equals((Object)DIFCell.CellType.BLANK) || cell.getCellType().equals((Object)DIFCell.CellType.STRING)) {
                        writer.println("1,0");
                        this.writeString(writer, cell.getStringCellValue());
                        continue;
                    }
                    if (cell.getCellType().equals((Object)DIFCell.CellType.BOOLEAN)) {
                        writer.println("0," + (cell.getBooleanCellValue() ? 1 : 0));
                        writer.println(Boolean.toString(cell.getBooleanCellValue()).toUpperCase());
                        continue;
                    }
                    if (cell.getCellType().equals((Object)DIFCell.CellType.NUMERIC)) {
                        writer.println("0," + cell.getNumericCellValue().toPlainString());
                        writer.println("V");
                        continue;
                    }
                    if (!cell.getCellType().equals((Object)DIFCell.CellType.DATE)) continue;
                    writer.println("0," + this.usFmt.format(cell.getDateCellValue()));
                    writer.println("V");
                    continue;
                }
                catch (DIFDataException ex) {
                    throw new RuntimeException("PANIC!", ex);
                }
            }
        }
        writer.flush();
    }

    private void writeTitle(PrintWriter writer, DIFSheet sheet) {
        writer.println("TABLE");
        writer.println("0," + sheet.getVersion());
        this.writeString(writer, sheet.getTitle());
    }

    private void writeString(PrintWriter writer, String data) {
        writer.println("\"" + data.replace("\"", "\"\"") + "\"");
    }

    private int writeVectors(PrintWriter writer, DIFSheet sheet) {
        writer.println(DIFKeywords.VECTORS.name());
        int vectors = 0;
        Iterator<DIFRow> i = sheet.rowIterator();
        while (i.hasNext()) {
            DIFRow row = i.next();
            vectors = Math.max(vectors, row.getLastCellNumber() + 1);
        }
        writer.println("0," + vectors);
        this.writeString(writer, "");
        return vectors;
    }

    private int writeTuples(PrintWriter writer, DIFSheet sheet) {
        int tuples = sheet.getLastRowNumber() + 1;
        writer.println(DIFKeywords.TUPLES.name());
        writer.println("0," + tuples);
        this.writeString(writer, "");
        return tuples;
    }

    private void writeData(PrintWriter writer) {
        writer.println(DIFKeywords.DATA.name());
        writer.println("0,0");
        this.writeString(writer, "");
    }
}

