/*
 * Decompiled with CFR 0.152.
 */
package com.csam.dif;

import com.csam.dif.DIFCell;
import com.csam.dif.DIFCellExistsException;
import com.csam.dif.DIFSheet;
import java.util.Iterator;
import java.util.TreeMap;

public final class DIFRow {
    private TreeMap<Integer, DIFCell> cells = new TreeMap();
    private DIFSheet sheet;
    private int rowNumber;

    protected DIFRow(DIFSheet sheet, int rowNumber) {
        this.sheet = sheet;
        this.rowNumber = rowNumber;
    }

    protected DIFSheet getSheet() {
        return this.sheet;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public DIFCell createCell(int cellNumber, DIFCell.CellType cellType) throws DIFCellExistsException {
        if (this.hasCell(cellNumber)) {
            throw new DIFCellExistsException(this.sheet, this.rowNumber, cellNumber);
        }
        DIFCell cell = new DIFCell(this.sheet, this.rowNumber, cellNumber, cellType);
        this.cells.put(cellNumber, cell);
        return cell;
    }

    public DIFCell createCell(int cellNumber) throws DIFCellExistsException {
        return this.createCell(cellNumber, DIFCell.CellType.BLANK);
    }

    public boolean hasCell(int cellNumber) {
        return this.cells.containsKey(cellNumber);
    }

    public Iterator<DIFCell> cellIterator() {
        return this.cells.values().iterator();
    }

    public int getPhysicalNumberOfCells() {
        return this.cells.size();
    }

    public int getFirstCellNumber() {
        return this.cells.firstKey();
    }

    public int getLastCellNumber() {
        return this.cells.lastKey();
    }

    public DIFCell getCell(int cellNumber) {
        return this.cells.get(cellNumber);
    }

    public void deleteCell(int cellNumber) {
        DIFCell cell = this.cells.remove(cellNumber);
        cell.cleanUp();
    }

    protected void cleanUp() {
        while (this.getPhysicalNumberOfCells() > 0) {
            int cellNum = this.getLastCellNumber();
            this.deleteCell(cellNum);
        }
    }
}

