/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictDimension;
import org.jfree.report.util.geom.StrictPoint;

public class ElementLayoutInformation {
    private StrictPoint absolutePosition;
    private StrictDimension minimumSize;
    private StrictDimension maximumSize;
    private StrictDimension preferredSize;

    public ElementLayoutInformation(StrictBounds rect) {
        StrictDimension fdim;
        if (rect == null) {
            throw new NullPointerException();
        }
        this.absolutePosition = new StrictPoint(rect.getX(), rect.getY());
        this.maximumSize = fdim = new StrictDimension(rect.getWidth(), rect.getHeight());
        this.minimumSize = fdim;
        this.preferredSize = fdim;
    }

    public ElementLayoutInformation(StrictPoint absolutePosition, StrictDimension minimumSize, StrictDimension maximumSize) {
        this(absolutePosition, minimumSize, maximumSize, null);
    }

    public ElementLayoutInformation(StrictPoint absolutePosition, StrictDimension minimumSize, StrictDimension maximumSize, StrictDimension preferredSize) {
        if (absolutePosition == null) {
            throw new NullPointerException();
        }
        if (minimumSize == null) {
            throw new NullPointerException();
        }
        if (maximumSize == null) {
            throw new NullPointerException();
        }
        this.absolutePosition = (StrictPoint)absolutePosition.clone();
        this.minimumSize = ElementLayoutInformation.unionMin(maximumSize, minimumSize);
        this.maximumSize = (StrictDimension)maximumSize.clone();
        if (preferredSize != null) {
            this.preferredSize = (StrictDimension)preferredSize.clone();
        }
    }

    public StrictPoint getAbsolutePosition() {
        return (StrictPoint)this.absolutePosition.clone();
    }

    public StrictDimension getMaximumSize() {
        return (StrictDimension)this.maximumSize.clone();
    }

    public StrictDimension getMinimumSize() {
        return (StrictDimension)this.minimumSize.clone();
    }

    public StrictDimension getPreferredSize() {
        if (this.preferredSize == null) {
            return null;
        }
        return (StrictDimension)this.preferredSize.clone();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("ElementLayoutInformation: \n");
        b.append("    AbsolutePos: ");
        b.append(this.absolutePosition);
        b.append("\n    MinSize: ");
        b.append(this.minimumSize);
        b.append("\n    PrefSize: ");
        b.append(this.preferredSize);
        b.append("\n    MaxSize: ");
        b.append(this.maximumSize);
        b.append("\n");
        return b.toString();
    }

    public static StrictDimension unionMin(StrictDimension max, StrictDimension pref) {
        if (pref == null) {
            return max;
        }
        return new StrictDimension(Math.min(pref.getWidth(), max.getWidth()), Math.min(pref.getHeight(), max.getHeight()));
    }
}

