/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.style;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.jfree.report.style.ElementDefaultStyleSheet;
import org.jfree.report.style.FontDefinition;
import org.jfree.report.style.StyleChangeListener;
import org.jfree.report.style.StyleChangeSupport;
import org.jfree.report.style.StyleKey;
import org.jfree.report.style.StyleSheetCarrier;
import org.jfree.report.util.InstanceID;
import org.jfree.report.util.SerializerHelper;

public abstract class ElementStyleSheet
implements Serializable,
StyleChangeListener,
Cloneable {
    private static final UndefinedValue UNDEFINED_VALUE = new UndefinedValue();
    public static final StyleKey MINIMUMSIZE = StyleKey.getStyleKey("min-size", class$java$awt$geom$Dimension2D != null ? class$java$awt$geom$Dimension2D : (class$java$awt$geom$Dimension2D = ElementStyleSheet.class$("java.awt.geom.Dimension2D")), false, false);
    public static final StyleKey MAXIMUMSIZE = StyleKey.getStyleKey("max-size", class$java$awt$geom$Dimension2D != null ? class$java$awt$geom$Dimension2D : (class$java$awt$geom$Dimension2D = ElementStyleSheet.class$("java.awt.geom.Dimension2D")), false, false);
    public static final StyleKey PREFERREDSIZE = StyleKey.getStyleKey("preferred-size", class$java$awt$geom$Dimension2D != null ? class$java$awt$geom$Dimension2D : (class$java$awt$geom$Dimension2D = ElementStyleSheet.class$("java.awt.geom.Dimension2D")), false, false);
    public static final StyleKey BOUNDS = StyleKey.getStyleKey("bounds", class$org$jfree$report$util$geom$StrictBounds != null ? class$org$jfree$report$util$geom$StrictBounds : (class$org$jfree$report$util$geom$StrictBounds = ElementStyleSheet.class$("org.jfree.report.util.geom.StrictBounds")), true, false);
    public static final StyleKey VISIBLE = StyleKey.getStyleKey("visible", class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ElementStyleSheet.class$("java.lang.Boolean")));
    public static final StyleKey PAINT = StyleKey.getStyleKey("paint", class$java$awt$Color != null ? class$java$awt$Color : (class$java$awt$Color = ElementStyleSheet.class$("java.awt.Color")));
    public static final StyleKey EXTPAINT = StyleKey.getStyleKey("ext-paint", class$java$awt$Paint != null ? class$java$awt$Paint : (class$java$awt$Paint = ElementStyleSheet.class$("java.awt.Paint")));
    public static final StyleKey STROKE = StyleKey.getStyleKey("stroke", class$java$awt$Stroke != null ? class$java$awt$Stroke : (class$java$awt$Stroke = ElementStyleSheet.class$("java.awt.Stroke")));
    public static final StyleKey FONT = StyleKey.getStyleKey("font", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ElementStyleSheet.class$("java.lang.String")));
    public static final StyleKey FONTSIZE = StyleKey.getStyleKey("font-size", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = ElementStyleSheet.class$("java.lang.Integer")));
    public static final StyleKey LINEHEIGHT = StyleKey.getStyleKey("line-height", class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = ElementStyleSheet.class$("java.lang.Float")));
    public static final StyleKey BOLD = StyleKey.getStyleKey("font-bold", class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ElementStyleSheet.class$("java.lang.Boolean")));
    public static final StyleKey ITALIC = StyleKey.getStyleKey("font-italic", class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ElementStyleSheet.class$("java.lang.Boolean")));
    public static final StyleKey UNDERLINED = StyleKey.getStyleKey("font-underline", class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ElementStyleSheet.class$("java.lang.Boolean")));
    public static final StyleKey STRIKETHROUGH = StyleKey.getStyleKey("font-strikethrough", class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ElementStyleSheet.class$("java.lang.Boolean")));
    public static final StyleKey EMBEDDED_FONT = StyleKey.getStyleKey("font-embedded", class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ElementStyleSheet.class$("java.lang.Boolean")));
    public static final StyleKey FONTENCODING = StyleKey.getStyleKey("font-encoding", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ElementStyleSheet.class$("java.lang.String")));
    public static final StyleKey ALIGNMENT = StyleKey.getStyleKey("alignment", class$org$jfree$report$ElementAlignment != null ? class$org$jfree$report$ElementAlignment : (class$org$jfree$report$ElementAlignment = ElementStyleSheet.class$("org.jfree.report.ElementAlignment")));
    public static final StyleKey VALIGNMENT = StyleKey.getStyleKey("valignment", class$org$jfree$report$ElementAlignment != null ? class$org$jfree$report$ElementAlignment : (class$org$jfree$report$ElementAlignment = ElementStyleSheet.class$("org.jfree.report.ElementAlignment")));
    public static final StyleKey SCALE = StyleKey.getStyleKey("scale", class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ElementStyleSheet.class$("java.lang.Boolean")));
    public static final StyleKey KEEP_ASPECT_RATIO = StyleKey.getStyleKey("keepAspectRatio", class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ElementStyleSheet.class$("java.lang.Boolean")));
    public static final StyleKey DYNAMIC_HEIGHT = StyleKey.getStyleKey("dynamic_height", class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ElementStyleSheet.class$("java.lang.Boolean")));
    public static final StyleKey ELEMENT_LAYOUT_CACHEABLE = StyleKey.getStyleKey("layout-cacheable", class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ElementStyleSheet.class$("java.lang.Boolean")));
    public static final StyleKey RESERVED_LITERAL = StyleKey.getStyleKey("reserved-literal", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ElementStyleSheet.class$("java.lang.String")));
    public static final StyleKey TRIM_TEXT_CONTENT = StyleKey.getStyleKey("trim-text-content", class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ElementStyleSheet.class$("java.lang.Boolean")));
    public static final StyleKey HREF_TARGET = StyleKey.getStyleKey("href-target", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ElementStyleSheet.class$("java.lang.String")));
    public static final StyleKey HREF_WINDOW = StyleKey.getStyleKey("href-html-window", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ElementStyleSheet.class$("java.lang.String")));
    public static final StyleKey HREF_INHERITED = StyleKey.getStyleKey("href-inherited", class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ElementStyleSheet.class$("java.lang.Boolean")), true, false);
    public static final StyleKey EXCEL_WRAP_TEXT = StyleKey.getStyleKey("Excel.WrapText", class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = ElementStyleSheet.class$("java.lang.Boolean")));
    public static final StyleKey EXCEL_DATA_FORMAT_STRING = StyleKey.getStyleKey("Excel.CellDataFormat", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ElementStyleSheet.class$("java.lang.String")));
    private InstanceID id;
    private String name;
    private ArrayList parents;
    private ElementDefaultStyleSheet globalDefaultStyleSheet;
    private ElementStyleSheet cascadeStyleSheet;
    private transient StyleSheetCarrier[] parentsCached;
    private transient StyleKey[] propertyKeys;
    private transient Object[] properties;
    private transient Object[] cachedProperties;
    private transient StyleChangeSupport styleChangeSupport;
    private boolean allowCaching;
    private transient FontDefinition fontDefinition;
    static /* synthetic */ Class class$java$awt$geom$Dimension2D;
    static /* synthetic */ Class class$org$jfree$report$util$geom$StrictBounds;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$awt$Paint;
    static /* synthetic */ Class class$java$awt$Stroke;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$org$jfree$report$ElementAlignment;

    protected ElementStyleSheet(String name) {
        if (name == null) {
            throw new NullPointerException("ElementStyleSheet constructor: name is null.");
        }
        this.id = new InstanceID();
        this.name = name;
        this.parents = new ArrayList(5);
        this.styleChangeSupport = new StyleChangeSupport(this);
    }

    protected void addListener(StyleChangeListener l) {
        this.styleChangeSupport.addListener(l);
    }

    public void addParent(int position, ElementStyleSheet parent) {
        StyleSheetCarrier carrier;
        if (parent == null) {
            throw new NullPointerException("ElementStyleSheet.addParent(...): parent is null.");
        }
        if (!parent.isSubStyleSheet(this)) {
            carrier = this.createCarrier(parent);
            if (carrier == null) {
                throw new IllegalArgumentException("The given StyleSheet cannot be added to this stylesheet.");
            }
        } else {
            throw new IllegalArgumentException("Cannot add parent as child.");
        }
        this.parents.add(position, carrier);
        this.parentsCached = null;
    }

    public void addParent(ElementStyleSheet parent) {
        this.addParent(0, parent);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            ElementStyleSheet sc = (ElementStyleSheet)super.clone();
            if (this.properties != null) {
                sc.properties = (Object[])this.properties.clone();
            }
            if (this.propertyKeys != null) {
                sc.propertyKeys = (StyleKey[])this.propertyKeys.clone();
            }
            sc.styleChangeSupport = new StyleChangeSupport(sc);
            if (this.cachedProperties != null) {
                sc.cachedProperties = (Object[])this.cachedProperties.clone();
            }
            this.parentsToCache();
            sc.parents = new ArrayList(this.parentsCached.length);
            sc.parentsCached = new StyleSheetCarrier[this.parentsCached.length];
            int i = 0;
            while (i < this.parentsCached.length) {
                StyleSheetCarrier carrier;
                sc.parentsCached[i] = carrier = (StyleSheetCarrier)this.parentsCached[i].clone();
                sc.parents.add(carrier);
                ++i;
            }
            sc.cascadeStyleSheet = null;
            sc.globalDefaultStyleSheet = this.globalDefaultStyleSheet;
            return sc;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Clone failed.");
        }
    }

    protected abstract StyleSheetCarrier createCarrier(ElementStyleSheet var1);

    public boolean getBooleanStyleProperty(StyleKey key) {
        return this.getBooleanStyleProperty(key, false);
    }

    public boolean getBooleanStyleProperty(StyleKey key, boolean defaultValue) {
        Boolean b = (Boolean)this.getStyleProperty(key, null);
        if (b == null) {
            return defaultValue;
        }
        return b;
    }

    public ElementStyleSheet getCascadeStyleSheet() {
        return this.cascadeStyleSheet;
    }

    public ElementStyleSheet getCopy() throws CloneNotSupportedException {
        return (ElementStyleSheet)this.clone();
    }

    public Iterator getDefinedPropertyNames() {
        ArrayList<StyleKey> al = new ArrayList<StyleKey>();
        if (this.propertyKeys != null) {
            int i = 0;
            while (i < this.propertyKeys.length) {
                if (this.propertyKeys[i] != null) {
                    al.add(this.propertyKeys[i]);
                }
                ++i;
            }
        }
        return Collections.unmodifiableList(al).iterator();
    }

    public FontDefinition getFontDefinitionProperty() {
        if (this.fontDefinition == null) {
            String name = (String)this.getStyleProperty(FONT);
            int size = this.getIntStyleProperty(FONTSIZE, -1);
            boolean bold = this.getBooleanStyleProperty(BOLD);
            boolean italic = this.getBooleanStyleProperty(ITALIC);
            boolean underlined = this.getBooleanStyleProperty(UNDERLINED);
            boolean strike = this.getBooleanStyleProperty(STRIKETHROUGH);
            boolean embed = this.getBooleanStyleProperty(EMBEDDED_FONT);
            String encoding = (String)this.getStyleProperty(FONTENCODING);
            FontDefinition retval = new FontDefinition(name, size, bold, italic, underlined, strike, encoding, embed);
            if (this.allowCaching) {
                this.fontDefinition = retval;
            } else {
                return retval;
            }
        }
        return this.fontDefinition;
    }

    public ElementDefaultStyleSheet getGlobalDefaultStyleSheet() {
        return this.globalDefaultStyleSheet;
    }

    public InstanceID getId() {
        return this.id;
    }

    public int getIntStyleProperty(StyleKey key, int def) {
        Integer i = (Integer)this.getStyleProperty(key, new Integer(def));
        return i;
    }

    public String getName() {
        return this.name;
    }

    protected StyleSheetCarrier[] getParentReferences() {
        this.parentsToCache();
        return this.parentsCached;
    }

    public ElementStyleSheet[] getParents() {
        if (this.parentsCached == null) {
            this.parentsToCache();
        }
        ElementStyleSheet[] styleSheets = new ElementStyleSheet[this.parentsCached.length];
        int i = 0;
        while (i < styleSheets.length) {
            styleSheets[i] = this.parentsCached[i].getStyleSheet();
            ++i;
        }
        return styleSheets;
    }

    public Object getStyleProperty(StyleKey key) {
        return this.getStyleProperty(key, null);
    }

    public Object getStyleProperty(StyleKey key, Object defaultValue) {
        Object value;
        Object value2;
        int identifier = key.getIdentifier();
        if (this.properties != null && this.properties.length > identifier && (value2 = this.properties[identifier]) != null) {
            return value2;
        }
        if (this.cachedProperties != null && this.cachedProperties.length > identifier && (value2 = this.cachedProperties[identifier]) != null) {
            if (value2 == UNDEFINED_VALUE) {
                return defaultValue;
            }
            return value2;
        }
        this.parentsToCache();
        int i = 0;
        while (i < this.parentsCached.length) {
            ElementStyleSheet st = this.parentsCached[i].getStyleSheet();
            Object value3 = st.getStyleProperty(key, null);
            if (value3 != null) {
                this.putInCache(key, value3);
                return value3;
            }
            ++i;
        }
        if (this.cascadeStyleSheet != null && key.isInheritable() && (value = this.cascadeStyleSheet.getStyleProperty(key, null)) != null) {
            this.putInCache(key, value);
            return value;
        }
        if (this.globalDefaultStyleSheet != null && (value = this.globalDefaultStyleSheet.getStyleProperty(key, null)) != null) {
            this.putInCache(key, value);
            return value;
        }
        this.putInCache(key, UNDEFINED_VALUE);
        return defaultValue;
    }

    public final boolean isAllowCaching() {
        return this.allowCaching;
    }

    private boolean isFontDefinitionProperty(StyleKey key) {
        if (key == FONT) {
            return true;
        }
        if (key == FONTSIZE) {
            return true;
        }
        if (key == BOLD) {
            return true;
        }
        if (key == ITALIC) {
            return true;
        }
        if (key == UNDERLINED) {
            return true;
        }
        if (key == STRIKETHROUGH) {
            return true;
        }
        if (key == EMBEDDED_FONT) {
            return true;
        }
        return key == FONTENCODING;
    }

    public boolean isGlobalDefault() {
        return false;
    }

    public boolean isLocalKey(StyleKey key) {
        if (this.properties == null) {
            return false;
        }
        int identifier = key.getIdentifier();
        if (this.properties.length <= identifier) {
            return false;
        }
        return this.properties[identifier] != null;
    }

    protected boolean isSubStyleSheet(ElementStyleSheet parent) {
        int i = 0;
        while (i < this.parents.size()) {
            StyleSheetCarrier ca = (StyleSheetCarrier)this.parents.get(i);
            ElementStyleSheet es = ca.getStyleSheet();
            if (es == parent) {
                return true;
            }
            if (es.isSubStyleSheet(parent)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void parentsToCache() {
        if (this.parentsCached == null) {
            this.parentsCached = this.parents.toArray(new StyleSheetCarrier[this.parents.size()]);
        }
    }

    private void putInCache(StyleKey key, Object value) {
        if (this.allowCaching) {
            int identifier = key.getIdentifier();
            if (this.cachedProperties != null) {
                if (this.cachedProperties.length <= identifier) {
                    Object[] newCache = new Object[StyleKey.getDefinedStyleKeyCount()];
                    System.arraycopy(this.cachedProperties, 0, newCache, 0, this.cachedProperties.length);
                    this.cachedProperties = newCache;
                }
            } else {
                this.cachedProperties = new Object[StyleKey.getDefinedStyleKeyCount()];
            }
            this.cachedProperties[identifier] = value;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.styleChangeSupport = new StyleChangeSupport(this);
        in.defaultReadObject();
        StyleKey[] keys = (StyleKey[])in.readObject();
        int size = in.readInt();
        Object[] values = new Object[size];
        int i = 0;
        while (i < size) {
            Object value;
            values[i] = value = SerializerHelper.getInstance().readObject(in);
            ++i;
        }
        if (keys == null) {
            return;
        }
        this.properties = new Object[StyleKey.getDefinedStyleKeyCount()];
        this.propertyKeys = new StyleKey[StyleKey.getDefinedStyleKeyCount()];
        int maxLen = Math.min(Math.min(this.properties.length, keys.length), Math.min(this.propertyKeys.length, values.length));
        int i2 = 0;
        while (i2 < maxLen) {
            StyleKey key = keys[i2];
            if (key != null) {
                Object value;
                int identifier = key.getIdentifier();
                this.properties[identifier] = value = values[i2];
                this.propertyKeys[identifier] = key;
            }
            ++i2;
        }
    }

    protected void removeListener(StyleChangeListener l) {
        this.styleChangeSupport.removeListener(l);
    }

    public void removeParent(ElementStyleSheet parent) {
        if (parent == null) {
            throw new NullPointerException("ElementStyleSheet.removeParent(...): parent is null.");
        }
        Iterator it = ((AbstractList)this.parents).iterator();
        while (it.hasNext()) {
            StyleSheetCarrier carrier = (StyleSheetCarrier)it.next();
            if (!carrier.isSame(parent)) continue;
            it.remove();
            carrier.invalidate();
        }
        this.parentsCached = null;
    }

    public void setAllowCaching(boolean allowCaching) {
        this.allowCaching = allowCaching;
        if (!this.allowCaching) {
            this.cachedProperties = null;
        }
    }

    public void setBooleanStyleProperty(StyleKey key, boolean value) {
        if (value) {
            this.setStyleProperty(key, Boolean.TRUE);
        } else {
            this.setStyleProperty(key, Boolean.FALSE);
        }
    }

    public void setCascadeStyleSheet(ElementStyleSheet cascadeStyleSheet) {
        if (this.cascadeStyleSheet != null) {
            this.cascadeStyleSheet.removeListener(this);
        }
        this.cascadeStyleSheet = cascadeStyleSheet;
        if (this.cascadeStyleSheet != null) {
            this.cascadeStyleSheet.addListener(this);
        }
    }

    public void setFontDefinitionProperty(FontDefinition font) {
        if (font == null) {
            throw new NullPointerException("ElementStyleSheet.setFontStyleProperty: font is null.");
        }
        this.setStyleProperty(FONT, font.getFontName());
        this.setStyleProperty(FONTSIZE, new Integer(font.getFontSize()));
        this.setBooleanStyleProperty(BOLD, font.isBold());
        this.setBooleanStyleProperty(ITALIC, font.isItalic());
        this.setBooleanStyleProperty(UNDERLINED, font.isUnderline());
        this.setBooleanStyleProperty(STRIKETHROUGH, font.isStrikeThrough());
        this.setBooleanStyleProperty(EMBEDDED_FONT, font.isEmbeddedFont());
        this.setStyleProperty(FONTENCODING, font.getFontEncoding(null));
    }

    public void setGlobalDefaultStyleSheet(ElementDefaultStyleSheet defaultStyleSheet) {
        this.globalDefaultStyleSheet = defaultStyleSheet;
    }

    public void setStyleProperty(StyleKey key, Object value) {
        if (key == null) {
            throw new NullPointerException("ElementStyleSheet.setStyleProperty: key is null.");
        }
        if (this.isFontDefinitionProperty(key)) {
            this.fontDefinition = null;
        }
        int identifier = key.getIdentifier();
        if (value == null) {
            if (this.properties != null && this.properties.length > identifier) {
                this.properties[identifier] = null;
            }
            if (this.propertyKeys != null && this.propertyKeys.length > identifier) {
                this.propertyKeys[identifier] = null;
            }
            this.styleChangeSupport.fireStyleRemoved(key);
        } else {
            Object[] newProps;
            if (!key.getValueType().isAssignableFrom(value.getClass())) {
                throw new ClassCastException("Value for key " + key.getName() + " is not assignable: " + value.getClass() + " is not assignable from " + key.getValueType());
            }
            if (this.properties != null) {
                if (this.properties.length <= identifier) {
                    newProps = new Object[StyleKey.getDefinedStyleKeyCount()];
                    System.arraycopy(this.properties, 0, newProps, 0, this.properties.length);
                    this.properties = newProps;
                }
            } else {
                this.properties = new Object[StyleKey.getDefinedStyleKeyCount()];
            }
            if (this.propertyKeys != null) {
                if (this.propertyKeys.length <= identifier) {
                    newProps = new StyleKey[StyleKey.getDefinedStyleKeyCount()];
                    System.arraycopy(this.propertyKeys, 0, newProps, 0, this.propertyKeys.length);
                    this.propertyKeys = newProps;
                }
            } else {
                this.propertyKeys = new StyleKey[StyleKey.getDefinedStyleKeyCount()];
            }
            this.properties[identifier] = value;
            this.propertyKeys[identifier] = key;
            this.styleChangeSupport.fireStyleChanged(key, value);
        }
    }

    public void styleChanged(ElementStyleSheet source, StyleKey key, Object value) {
        if (this.cachedProperties != null) {
            int identifier = key.getIdentifier();
            if (this.cachedProperties.length > identifier) {
                this.cachedProperties[identifier] = value;
            }
            if (this.isFontDefinitionProperty(key)) {
                this.fontDefinition = null;
            }
        }
        this.styleChangeSupport.fireStyleChanged(key, value);
    }

    public void styleRemoved(ElementStyleSheet source, StyleKey key) {
        if (this.cachedProperties != null) {
            int identifier = key.getIdentifier();
            if (this.cachedProperties.length > identifier) {
                this.cachedProperties[identifier] = null;
            }
            if (this.isFontDefinitionProperty(key)) {
                this.fontDefinition = null;
            }
        }
        this.styleChangeSupport.fireStyleRemoved(key);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.propertyKeys);
        if (this.properties == null) {
            out.writeInt(0);
        } else {
            int size = this.properties.length;
            out.writeInt(size);
            int i = 0;
            while (i < size) {
                Object value = this.properties[i];
                SerializerHelper.getInstance().writeObject(value, out);
                ++i;
            }
        }
    }

    private static class UndefinedValue {
    }
}

