/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.style;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import org.jfree.report.ElementAlignment;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.FontDefinition;
import org.jfree.report.style.StyleKey;
import org.jfree.report.style.StyleSheetCarrier;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.ui.FloatDimension;

public class ElementDefaultStyleSheet
extends ElementStyleSheet {
    public static final Color DEFAULT_PAINT = Color.black;
    public static final Stroke DEFAULT_STROKE = new BasicStroke();
    public static final FontDefinition DEFAULT_FONT_DEFINITION = new FontDefinition("Serif", 10);
    private static ElementDefaultStyleSheet defaultStyle;
    private boolean locked;

    protected ElementDefaultStyleSheet(String name) {
        super(name);
        this.setStyleProperty(ElementStyleSheet.MINIMUMSIZE, new FloatDimension(0.0f, 0.0f));
        this.setStyleProperty(ElementStyleSheet.MAXIMUMSIZE, new FloatDimension(32767.0f, 32767.0f));
        StrictBounds value = new StrictBounds();
        this.setStyleProperty(ElementStyleSheet.BOUNDS, value.getLockedInstance());
        this.setStyleProperty(ElementStyleSheet.PAINT, DEFAULT_PAINT);
        this.setStyleProperty(ElementStyleSheet.STROKE, DEFAULT_STROKE);
        this.setFontDefinitionProperty(DEFAULT_FONT_DEFINITION);
        this.setStyleProperty(ElementStyleSheet.VALIGNMENT, ElementAlignment.TOP);
        this.setStyleProperty(ElementStyleSheet.ALIGNMENT, ElementAlignment.LEFT);
        this.setStyleProperty(ElementStyleSheet.VISIBLE, Boolean.TRUE);
        this.setStyleProperty(ElementStyleSheet.LINEHEIGHT, new Float(0.0f));
        this.setStyleProperty(ElementStyleSheet.ELEMENT_LAYOUT_CACHEABLE, Boolean.TRUE);
        this.setLocked(true);
    }

    protected StyleSheetCarrier createCarrier(ElementStyleSheet styleSheet) {
        throw new UnsupportedOperationException("Cannot add other stylesheets as parent to the global default stylesheet");
    }

    public ElementStyleSheet getCopy() {
        return this;
    }

    public static ElementDefaultStyleSheet getDefaultStyle() {
        if (defaultStyle == null) {
            defaultStyle = new ElementDefaultStyleSheet("GlobalElement");
        }
        return defaultStyle;
    }

    public boolean isGlobalDefault() {
        return true;
    }

    protected boolean isLocked() {
        return this.locked;
    }

    protected void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setStyleProperty(StyleKey key, Object value) {
        if (this.isLocked()) {
            throw new UnsupportedOperationException("This stylesheet is readonly");
        }
        super.setStyleProperty(key, value);
    }
}

