/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.states;

import java.util.ResourceBundle;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.report.DataRow;
import org.jfree.report.Group;
import org.jfree.report.GroupList;
import org.jfree.report.ItemBand;
import org.jfree.report.NoDataBand;
import org.jfree.report.PageDefinition;
import org.jfree.report.PageFooter;
import org.jfree.report.PageHeader;
import org.jfree.report.ReportDefinition;
import org.jfree.report.ReportFooter;
import org.jfree.report.ReportHeader;
import org.jfree.report.ResourceBundleFactory;
import org.jfree.report.Watermark;
import org.jfree.report.states.DataRowConnector;
import org.jfree.report.states.UnmodifiableGroupList;
import org.jfree.report.style.StyleSheetCollection;
import org.jfree.report.util.ReportProperties;

public class ReportDefinitionImpl
implements ReportDefinition {
    private GroupList groups;
    private ReportHeader reportHeader;
    private ReportFooter reportFooter;
    private PageHeader pageHeader;
    private PageFooter pageFooter;
    private ItemBand itemBand;
    private Watermark watermark;
    private NoDataBand noDataBand;
    private ReportProperties properties;
    private final ModifiableConfiguration reportConfiguration;
    private StyleSheetCollection styleSheetCollection;
    private DataRowConnector dataRowConnector;
    private PageDefinition pageDefinition;
    private ResourceBundleFactory resourceBundleFactory;

    public ReportDefinitionImpl(ReportDefinition report) throws CloneNotSupportedException {
        this.groups = new UnmodifiableGroupList((GroupList)report.getGroups().clone());
        this.properties = (ReportProperties)report.getProperties().clone();
        this.reportFooter = (ReportFooter)report.getReportFooter().clone();
        this.reportHeader = (ReportHeader)report.getReportHeader().clone();
        this.pageFooter = (PageFooter)report.getPageFooter().clone();
        this.pageHeader = (PageHeader)report.getPageHeader().clone();
        this.itemBand = (ItemBand)report.getItemBand().clone();
        this.watermark = (Watermark)report.getWatermark().clone();
        this.noDataBand = (NoDataBand)report.getNoDataBand().clone();
        this.reportConfiguration = report.getReportConfiguration();
        this.pageDefinition = (PageDefinition)report.getPageDefinition().clone();
        this.styleSheetCollection = (StyleSheetCollection)report.getStyleSheetCollection().clone();
        this.resourceBundleFactory = report.getResourceBundleFactory();
        this.dataRowConnector = new DataRowConnector();
        this.groups.setReportDefinition(this);
        this.reportHeader.setReportDefinition(this);
        this.reportFooter.setReportDefinition(this);
        this.pageHeader.setReportDefinition(this);
        this.pageFooter.setReportDefinition(this);
        this.itemBand.setReportDefinition(this);
        this.watermark.setReportDefinition(this);
    }

    public Object clone() throws CloneNotSupportedException {
        ReportDefinitionImpl report = (ReportDefinitionImpl)super.clone();
        report.groups = (GroupList)this.groups.clone();
        report.itemBand = (ItemBand)this.itemBand.clone();
        report.pageFooter = (PageFooter)this.pageFooter.clone();
        report.pageHeader = (PageHeader)this.pageHeader.clone();
        report.properties = (ReportProperties)this.properties.clone();
        report.reportFooter = (ReportFooter)this.reportFooter.clone();
        report.reportHeader = (ReportHeader)this.reportHeader.clone();
        report.watermark = (Watermark)this.watermark.clone();
        report.pageDefinition = this.pageDefinition;
        report.styleSheetCollection = (StyleSheetCollection)this.styleSheetCollection.clone();
        report.dataRowConnector = new DataRowConnector();
        report.groups.setReportDefinition(report);
        report.reportHeader.setReportDefinition(report);
        report.reportFooter.setReportDefinition(report);
        report.pageHeader.setReportDefinition(report);
        report.pageFooter.setReportDefinition(report);
        report.itemBand.setReportDefinition(report);
        report.watermark.setReportDefinition(report);
        return report;
    }

    public DataRow getDataRow() {
        return this.dataRowConnector;
    }

    public DataRowConnector getDataRowConnector() {
        return this.dataRowConnector;
    }

    public Group getGroup(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("GroupCount must not be negative");
        }
        if (count >= this.groups.size()) {
            throw new IndexOutOfBoundsException("No such group defined. " + count + " vs. " + this.groups.size());
        }
        return this.groups.get(count);
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public GroupList getGroups() {
        return this.groups;
    }

    public ItemBand getItemBand() {
        return this.itemBand;
    }

    public NoDataBand getNoDataBand() {
        return this.noDataBand;
    }

    public PageDefinition getPageDefinition() {
        return this.pageDefinition;
    }

    public PageFooter getPageFooter() {
        return this.pageFooter;
    }

    public PageHeader getPageHeader() {
        return this.pageHeader;
    }

    public ReportProperties getProperties() {
        return this.properties;
    }

    public ModifiableConfiguration getReportConfiguration() {
        return this.reportConfiguration;
    }

    public ReportFooter getReportFooter() {
        return this.reportFooter;
    }

    public ReportHeader getReportHeader() {
        return this.reportHeader;
    }

    public ResourceBundle getResourceBundle(String identifier) {
        return this.getResourceBundleFactory().getResourceBundle(identifier);
    }

    public ResourceBundleFactory getResourceBundleFactory() {
        return this.resourceBundleFactory;
    }

    public StyleSheetCollection getStyleSheetCollection() {
        return this.styleSheetCollection;
    }

    public Watermark getWatermark() {
        return this.watermark;
    }
}

