/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.states;

import org.jfree.report.Group;
import org.jfree.report.states.PostItemGroupState;
import org.jfree.report.states.ReportState;

public final class InItemGroupState
extends ReportState {
    private boolean prevStateWasPrefetch;

    public InItemGroupState(ReportState previous) {
        super(previous);
        this.prevStateWasPrefetch = previous.isPrefetchState();
        this.getDataRowBackend().setCurrentRow(this.getCurrentDisplayItem());
    }

    public ReportState advance() {
        this.firePrepareEvent();
        this.prevStateWasPrefetch = false;
        this.advanceItem();
        this.fireItemsAdvancedEvent();
        Group group = this.getReport().getGroup(this.getCurrentGroupIndex());
        if (ReportState.isLastItemInGroup(group, this.getDataRowBackend(), this.getDataRowPreview())) {
            return new PostItemGroupState(this);
        }
        return this;
    }

    private void advanceItem() {
        this.setCurrentDataItem(this.getCurrentDataItem() + 1);
        this.getDataRowBackend().setCurrentRow(this.getCurrentDisplayItem());
    }

    public int getEventCode() {
        return 32;
    }

    public boolean isPrefetchState() {
        return this.prevStateWasPrefetch;
    }

    public boolean isPrevStateWasPrefetch() {
        return this.prevStateWasPrefetch;
    }
}

