/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.resourceloader;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.jfree.io.IOUtils;
import org.jfree.report.resourceloader.ImageFactoryModule;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public class ImageFactory {
    private static ImageFactory singleton;
    private ArrayList factoryModules = new ArrayList();

    private ImageFactory() {
    }

    public Image createImage(InputStream in, String fileName, String mimeType) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(32768);
        IOUtils.getInstance().copyStreams(in, (OutputStream)bout, 16384);
        return this.createImage(bout.toByteArray(), fileName, mimeType);
    }

    public Image createImage(URL url) throws IOException {
        InputStream in = url.openStream();
        URLConnection uc = url.openConnection();
        Image image = this.createImage(uc.getInputStream(), url.getFile(), uc.getContentType());
        in.close();
        return image;
    }

    public synchronized Image createImage(byte[] data, String fileName, String mimeType) throws IOException {
        ImageFactoryModule module;
        int i = 0;
        while (i < this.factoryModules.size()) {
            try {
                ImageFactoryModule module2 = (ImageFactoryModule)this.factoryModules.get(i);
                if (module2.getHeaderFingerprintSize() > 0 && data.length >= module2.getHeaderFingerprintSize() && module2.canHandleResourceByContent(data)) {
                    return module2.createImage(data, fileName, mimeType);
                }
            }
            catch (IOException ioe) {
                Log.debug((Object)"Failed to load image: Trying harder ..", (Exception)ioe);
            }
            ++i;
        }
        if (mimeType != null && !"".equals(mimeType)) {
            int i2 = 0;
            while (i2 < this.factoryModules.size()) {
                try {
                    module = (ImageFactoryModule)this.factoryModules.get(i2);
                    if (module.canHandleResourceByMimeType(mimeType)) {
                        return module.createImage(data, fileName, mimeType);
                    }
                }
                catch (IOException ioe) {
                    Log.debug((Object)"Failed to load image: Trying harder ..", (Exception)ioe);
                }
                ++i2;
            }
        }
        if (mimeType != null && !"".equals(mimeType)) {
            int i3 = 0;
            while (i3 < this.factoryModules.size()) {
                try {
                    module = (ImageFactoryModule)this.factoryModules.get(i3);
                    if (module.canHandleResourceByName(fileName)) {
                        return module.createImage(data, fileName, mimeType);
                    }
                }
                catch (IOException ioe) {
                    Log.debug((Object)"Failed to load image: Trying harder ..", (Exception)ioe);
                }
                ++i3;
            }
        }
        Log.debug((Object)"Failed to find suitable factory for image: Using the AWT as fallback ..");
        return Toolkit.getDefaultToolkit().createImage(data);
    }

    public static synchronized ImageFactory getInstance() {
        if (singleton == null) {
            singleton = new ImageFactory();
        }
        return singleton;
    }

    public boolean registerModule(String className) {
        try {
            Class<?> c = ObjectUtilities.getClassLoader(this.getClass()).loadClass(className);
            this.registerModule((ImageFactoryModule)c.newInstance());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public synchronized void registerModule(ImageFactoryModule module) {
        if (!this.factoryModules.contains(module)) {
            this.factoryModules.add(module);
        }
    }
}

