/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.extwriter;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.ext.factory.templates.TemplateDescription;
import org.jfree.report.modules.parser.extwriter.ObjectWriter;
import org.jfree.report.modules.parser.extwriter.ReportWriter;
import org.jfree.report.modules.parser.extwriter.ReportWriterException;
import org.jfree.util.ObjectUtilities;
import org.jfree.xml.writer.AttributeList;

public class TemplateWriter
extends ObjectWriter {
    private TemplateDescription template;
    private TemplateDescription parent;

    public TemplateWriter(ReportWriter reportWriter, int indentLevel, TemplateDescription template, TemplateDescription parent, CommentHintPath path) {
        super(reportWriter, template, indentLevel, path);
        if (template == null) {
            throw new NullPointerException("Template is null.");
        }
        if (parent == null) {
            throw new NullPointerException("Parent is null.");
        }
        this.parent = parent;
        this.template = template;
    }

    private boolean shouldWriteParameter(String parameterName) {
        Object parameterObject = this.template.getParameter(parameterName);
        if (parameterObject == null) {
            return false;
        }
        Object parentObject = this.parent.getParameter(parameterName);
        return !ObjectUtilities.equal((Object)parameterObject, (Object)parentObject);
    }

    public void write(Writer writer) throws IOException, ReportWriterException {
        AttributeList p = new AttributeList();
        if (this.template.getName() != null && !this.template.getName().equals(this.parent.getName())) {
            p.setAttribute("name", this.template.getName());
        }
        p.setAttribute("references", this.parent.getName());
        boolean tagWritten = false;
        Iterator it = this.template.getParameterNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!this.shouldWriteParameter(name)) continue;
            if (!tagWritten) {
                this.writeComment(writer, this.getCommentHintPath(), "parser.comment.open");
                this.writeTag(writer, "template", p, false);
                tagWritten = true;
            }
            this.writeParameter(writer, name);
        }
        if (tagWritten) {
            this.writeComment(writer, this.getCommentHintPath(), "parser.comment.close");
            this.writeCloseTag(writer, "template");
        } else {
            this.writeComment(writer, this.getCommentHintPath(), "parser.comment.open");
            this.writeTag(writer, "template", p, true);
        }
    }
}

