/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.ext.readhandlers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.modules.parser.ext.readhandlers.BasicObjectReadHandler;
import org.jfree.report.modules.parser.ext.readhandlers.ObjectFactoryUtility;
import org.jfree.xml.ElementDefinitionException;
import org.jfree.xml.factory.objects.ClassFactory;
import org.jfree.xml.factory.objects.ObjectDescription;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CompoundObjectReadHandler
extends BasicObjectReadHandler {
    private HashMap basicObjects = new HashMap();
    private HashMap compoundObjects = new HashMap();

    public CompoundObjectReadHandler(ObjectDescription objectDescription, CommentHintPath commentPath) {
        super(objectDescription, commentPath);
    }

    protected void doneParsing() throws SAXException, XmlReaderException {
        ObjectDescription objectDescription = this.getObjectDescription();
        Iterator basicObjectsEntries = this.basicObjects.entrySet().iterator();
        while (basicObjectsEntries.hasNext()) {
            Map.Entry entry = basicObjectsEntries.next();
            String name = (String)entry.getKey();
            BasicObjectReadHandler readHandler = (BasicObjectReadHandler)((Object)entry.getValue());
            objectDescription.setParameter(name, readHandler.getObject());
        }
        Iterator compoundObjectsEntries = this.compoundObjects.entrySet().iterator();
        while (compoundObjectsEntries.hasNext()) {
            Map.Entry entry = compoundObjectsEntries.next();
            String name = (String)entry.getKey();
            CompoundObjectReadHandler readHandler = (CompoundObjectReadHandler)((Object)entry.getValue());
            objectDescription.setParameter(name, readHandler.getObject());
        }
        this.storeCloseComments();
        this.storeComments();
    }

    protected HashMap getBasicObjects() {
        return this.basicObjects;
    }

    protected HashMap getCompoundObjects() {
        return this.compoundObjects;
    }

    protected XmlReadHandler getHandlerForChild(String tagName, PropertyAttributes atts) throws XmlReaderException, SAXException {
        if (tagName.equals("basic-object")) {
            return this.handleBasicObject(atts);
        }
        if (tagName.equals("compound-object")) {
            return this.handleCompoundObject(atts);
        }
        return null;
    }

    protected XmlReadHandler handleBasicObject(Attributes atts) throws ElementDefinitionException {
        String name = atts.getValue("name");
        if (name == null) {
            throw new ElementDefinitionException("Required attribute 'name' is missing.");
        }
        ClassFactory fact = this.getClassFactory();
        Class paramDesc = this.getObjectDescription().getParameterDefinition(name);
        if (paramDesc == null) {
            this.getObjectDescription().getParameterDefinition(name);
            throw new ElementDefinitionException("The parameter type for '" + name + "' is not known.");
        }
        ObjectDescription objectDescription = ObjectFactoryUtility.findDescription(fact, paramDesc);
        CommentHintPath path = this.getCommentHintPath().getInstance();
        path.addName(name);
        BasicObjectReadHandler readHandler = new BasicObjectReadHandler(objectDescription, path);
        this.basicObjects.put(name, readHandler);
        return readHandler;
    }

    protected XmlReadHandler handleCompoundObject(Attributes atts) throws ElementDefinitionException {
        String name = atts.getValue("name");
        if (name == null) {
            throw new ElementDefinitionException("Required attribute 'name' is missing.");
        }
        ClassFactory fact = this.getClassFactory();
        ObjectDescription objectDescription = ObjectFactoryUtility.findDescription(fact, this.getObjectDescription().getParameterDefinition(name));
        CommentHintPath path = this.getCommentHintPath().getInstance();
        path.addName(name);
        CompoundObjectReadHandler readHandler = new CompoundObjectReadHandler(objectDescription, path);
        this.compoundObjects.put(name, readHandler);
        return readHandler;
    }

    protected void startParsing(PropertyAttributes attrs) throws SAXException, XmlReaderException {
        this.handleStartParsing(attrs);
    }
}

