/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.base;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import org.jfree.util.Log;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ParserEntityResolver
implements EntityResolver {
    private final Hashtable deprecatedDTDs;
    private final Hashtable dtds = new Hashtable();
    private static ParserEntityResolver singleton;

    private ParserEntityResolver() {
        this.deprecatedDTDs = new Hashtable();
    }

    public URL getDTDLocation(String publicID) {
        return (URL)this.dtds.get(publicID);
    }

    public static ParserEntityResolver getDefaultResolver() {
        if (singleton == null) {
            singleton = new ParserEntityResolver();
        }
        return singleton;
    }

    public String getDeprecatedDTDMessage(String publicID) {
        return (String)this.deprecatedDTDs.get(publicID);
    }

    private boolean isValid(URL reportDtd) {
        if (reportDtd == null) {
            return false;
        }
        try {
            InputStream uc = reportDtd.openStream();
            uc.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        try {
            if (publicId == null) {
                return null;
            }
            URL location = this.getDTDLocation(publicId);
            if (location != null) {
                return new InputSource(location.openStream());
            }
            String message = this.getDeprecatedDTDMessage(publicId);
            if (message != null) {
                Log.info((Object)message);
            } else {
                Log.info((Object)"A public ID was given for the document, but it was unknown or invalid.");
            }
            return null;
        }
        catch (IOException ioe) {
            Log.warn((Object)"Unable to open specified DTD", (Exception)ioe);
            return null;
        }
    }

    public boolean setDTDLocation(String publicID, URL location) {
        if (this.isValid(location)) {
            this.dtds.put(publicID, location);
            return true;
        }
        Log.warn((Object)new Log.SimpleMessage("Validate location failed for ", (Object)publicID, (Object)" location: ", (Object)location));
        return false;
    }

    public void setDeprecatedDTDMessage(String publicID, String message) {
        this.deprecatedDTDs.put(publicID, message);
    }
}

