/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.xls.util;

import java.awt.Color;
import java.util.HashMap;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jfree.report.modules.output.table.xls.HSSFFontWrapper;
import org.jfree.report.style.FontDefinition;

public class ExcelFontFactory {
    private HashMap fonts = new HashMap();
    private final HSSFWorkbook workbook;

    public ExcelFontFactory(HSSFWorkbook workbook) {
        this.workbook = workbook;
        FontDefinition font = new FontDefinition("Arial", 10);
        HSSFFontWrapper wrapper = new HSSFFontWrapper(font, Color.black);
        this.getExcelFont(wrapper);
    }

    private HSSFFont createFont(HSSFFontWrapper wrapper) {
        HSSFFont font = this.workbook.createFont();
        if (wrapper.isBold()) {
            font.setBoldweight((short)700);
        } else {
            font.setBoldweight((short)400);
        }
        font.setColor(wrapper.getColorIndex());
        font.setFontName(wrapper.getFontName());
        font.setFontHeightInPoints((short)wrapper.getFontHeight());
        font.setItalic(wrapper.isItalic());
        font.setStrikeout(wrapper.isStrikethrough());
        if (wrapper.isUnderline()) {
            font.setUnderline((byte)1);
        } else {
            font.setUnderline((byte)0);
        }
        return font;
    }

    public HSSFFont getExcelFont(HSSFFontWrapper wrapper) {
        if (this.fonts.containsKey(wrapper)) {
            return (HSSFFont)this.fonts.get(wrapper);
        }
        HSSFFont excelFont = this.createFont(wrapper);
        this.fonts.put(wrapper, excelFont);
        return excelFont;
    }
}

