/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.xls;

import java.awt.Color;
import org.jfree.report.modules.output.table.xls.util.ExcelColorSupport;
import org.jfree.report.style.FontDefinition;

public final class HSSFFontWrapper {
    public static final int FONT_FACTOR = 20;
    private final String fontName;
    private final short colorIndex;
    private final int fontHeight;
    private final boolean bold;
    private final boolean italic;
    private final boolean underline;
    private final boolean strikethrough;
    private int hashCode;

    public HSSFFontWrapper(FontDefinition font, Color color) {
        if (font == null) {
            throw new NullPointerException("FontDefinition is null");
        }
        if (color == null) {
            throw new NullPointerException("Color is null");
        }
        String fName = font.getFontName();
        this.fontName = font.isSansSerif() ? "Arial" : (font.isCourier() ? "Courier New" : (font.isSerif() ? "Times New Roman" : fName));
        this.colorIndex = ExcelColorSupport.getNearestColor(color);
        this.fontHeight = (short)font.getFontSize();
        this.bold = font.isBold();
        this.italic = font.isItalic();
        this.underline = font.isUnderline();
        this.strikethrough = font.isStrikeThrough();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HSSFFontWrapper)) {
            return false;
        }
        HSSFFontWrapper wrapper = (HSSFFontWrapper)o;
        if (this.bold != wrapper.bold) {
            return false;
        }
        if (this.underline != wrapper.strikethrough) {
            return false;
        }
        if (this.strikethrough != wrapper.strikethrough) {
            return false;
        }
        if (this.colorIndex != wrapper.colorIndex) {
            return false;
        }
        if (this.fontHeight != wrapper.fontHeight) {
            return false;
        }
        if (this.italic != wrapper.italic) {
            return false;
        }
        return this.fontName.equals(wrapper.fontName);
    }

    public short getColorIndex() {
        return this.colorIndex;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.fontName.hashCode();
            result = 29 * result + this.colorIndex;
            result = 29 * result + this.fontHeight;
            result = 29 * result + (this.bold ? 1 : 0);
            this.hashCode = result = 29 * result + (this.italic ? 1 : 0);
        }
        return this.hashCode;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isStrikethrough() {
        return this.strikethrough;
    }

    public boolean isUnderline() {
        return this.underline;
    }
}

