/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.xls;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jfree.report.DefaultImageReference;
import org.jfree.report.Element;
import org.jfree.report.ElementAlignment;
import org.jfree.report.content.AnchorContentFactoryModule;
import org.jfree.report.content.Content;
import org.jfree.report.content.ContentCreationException;
import org.jfree.report.content.ContentFactory;
import org.jfree.report.content.DefaultContentFactory;
import org.jfree.report.content.DrawableContentFactoryModule;
import org.jfree.report.content.EmptyContent;
import org.jfree.report.content.ImageContent;
import org.jfree.report.content.ImageContentFactoryModule;
import org.jfree.report.content.MultipartContent;
import org.jfree.report.content.ShapeContentFactoryModule;
import org.jfree.report.content.TextContentFactoryModule;
import org.jfree.report.filter.DataSource;
import org.jfree.report.filter.DataTarget;
import org.jfree.report.filter.DateFormatFilter;
import org.jfree.report.filter.FormatFilter;
import org.jfree.report.filter.NumberFormatFilter;
import org.jfree.report.filter.RawDataSource;
import org.jfree.report.filter.templates.DateFieldTemplate;
import org.jfree.report.filter.templates.NumberFieldTemplate;
import org.jfree.report.layout.DefaultLayoutSupport;
import org.jfree.report.layout.LayoutSupport;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.pageable.base.operations.AlignmentTools;
import org.jfree.report.modules.output.pageable.base.operations.HorizontalBoundsAlignment;
import org.jfree.report.modules.output.pageable.base.operations.VerticalBoundsAlignment;
import org.jfree.report.modules.output.table.base.RawContent;
import org.jfree.report.modules.output.table.base.TableMetaBandProducer;
import org.jfree.report.modules.output.table.xls.metaelements.ExcelDateMetaElement;
import org.jfree.report.modules.output.table.xls.metaelements.ExcelImageElement;
import org.jfree.report.modules.output.table.xls.metaelements.ExcelMetaElement;
import org.jfree.report.modules.output.table.xls.metaelements.ExcelNumberMetaElement;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.ElementLayoutInformation;
import org.jfree.report.util.ImageUtils;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictGeomUtility;
import org.jfree.ui.Drawable;
import org.jfree.util.Log;

public class ExcelMetaBandProducer
extends TableMetaBandProducer {
    private boolean defineDataFormats;

    public ExcelMetaBandProducer(boolean defineDataFormats, boolean useMaxLineHeight) {
        super(new DefaultLayoutSupport(ExcelMetaBandProducer.createExcelContentFactory(), useMaxLineHeight));
        this.defineDataFormats = defineDataFormats;
    }

    protected Content alignContent(Content content, StrictBounds bounds, ElementAlignment hAlign, ElementAlignment vAlign) {
        VerticalBoundsAlignment vba = AlignmentTools.getVerticalLayout(vAlign, bounds);
        StrictBounds minimumContentSize = content.getMinimumContentSize();
        if (minimumContentSize == null) {
            return EmptyContent.getDefaultEmptyContent();
        }
        StrictBounds cb = vba.align((StrictBounds)minimumContentSize.clone());
        long verticalShift = cb.getY() - minimumContentSize.getY();
        content.translate(0L, verticalShift);
        return this.alignHorizontalContent(content, bounds, hAlign);
    }

    protected Content alignHorizontalContent(Content content, StrictBounds bounds, ElementAlignment hAlign) {
        HorizontalBoundsAlignment hba = AlignmentTools.getHorizontalLayout(hAlign, bounds);
        StrictBounds minimumContentSize = content.getMinimumContentSize();
        if (minimumContentSize == null) {
            return EmptyContent.getDefaultEmptyContent();
        }
        StrictBounds cb = hba.align((StrictBounds)minimumContentSize.clone());
        long horizontalShift = cb.getX() - minimumContentSize.getX();
        content.translate(horizontalShift, 0L);
        if (content instanceof MultipartContent) {
            MultipartContent mp = (MultipartContent)content;
            int size = mp.getContentPartCount();
            int i = 0;
            while (i < size) {
                this.alignHorizontalContent(mp.getContentPart(i), bounds, hAlign);
                ++i;
            }
        }
        return content;
    }

    protected Content createContent(Element e, ElementStyleSheet styleSheet) throws ContentCreationException {
        StrictBounds bounds = (StrictBounds)styleSheet.getStyleProperty(ElementStyleSheet.BOUNDS);
        ElementAlignment hAlign = (ElementAlignment)styleSheet.getStyleProperty(ElementStyleSheet.ALIGNMENT);
        ElementAlignment vAlign = (ElementAlignment)styleSheet.getStyleProperty(ElementStyleSheet.VALIGNMENT);
        LayoutSupport support = this.getLayoutSupport();
        ElementLayoutInformation eli = new ElementLayoutInformation(bounds);
        Content content = support.getContentFactory().createContentForElement(e, eli, support);
        if (content.equals(EmptyContent.getDefaultEmptyContent())) {
            return content;
        }
        return this.alignContent(content, bounds, hAlign, vAlign);
    }

    private MetaElement createDateCell(Element e, long x, long y) {
        RawDataSource dft = (RawDataSource)e.getDataSource();
        Date date = (Date)dft.getRawValue();
        StrictBounds rect = (StrictBounds)e.getStyle().getStyleProperty(ElementStyleSheet.BOUNDS);
        ElementStyleSheet styleSheet = this.createStyleForTextElement(e, x, y);
        styleSheet.setStyleProperty(ElementStyleSheet.EXCEL_DATA_FORMAT_STRING, e.getStyle().getStyleProperty(ElementStyleSheet.EXCEL_DATA_FORMAT_STRING, this.getFormatString(dft)));
        return new ExcelDateMetaElement(new RawContent(rect, date), styleSheet);
    }

    protected MetaElement createDrawableCell(Element e, long x, long y) {
        DefaultImageReference imgref;
        Object o = e.getValue();
        if (!(o instanceof Drawable)) {
            return null;
        }
        Drawable drawable = (Drawable)o;
        StrictBounds rect = (StrictBounds)e.getStyle().getStyleProperty(ElementStyleSheet.BOUNDS);
        int imageWidth = (int)StrictGeomUtility.toExternalValue(rect.getWidth());
        int imageHeight = (int)StrictGeomUtility.toExternalValue(rect.getHeight());
        if (imageWidth == 0 && imageHeight == 0) {
            return null;
        }
        BufferedImage image = ImageUtils.createTransparentImage(imageWidth, imageHeight);
        Graphics2D g2 = (Graphics2D)((Image)image).getGraphics();
        drawable.draw(g2, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, imageWidth, imageHeight));
        g2.dispose();
        try {
            imgref = new DefaultImageReference(image);
        }
        catch (IOException iOException) {
            Log.warn((Object)"Unable to fully load a given image. (It should not happen here.)");
            return null;
        }
        ImageContent ic = new ImageContent(imgref, (StrictBounds)rect.clone());
        ElementStyleSheet styleSheet = this.createStyleForTextElement(e, x, y);
        StrictBounds bounds = (StrictBounds)styleSheet.getStyleProperty(ElementStyleSheet.BOUNDS);
        ElementAlignment hAlign = (ElementAlignment)styleSheet.getStyleProperty(ElementStyleSheet.ALIGNMENT);
        ElementAlignment vAlign = (ElementAlignment)styleSheet.getStyleProperty(ElementStyleSheet.VALIGNMENT);
        Content content = this.alignContent(ic, bounds, hAlign, vAlign);
        if (!(content instanceof ImageContent)) {
            return null;
        }
        ExcelImageElement me = new ExcelImageElement((ImageContent)content, styleSheet);
        me.setName(e.getName());
        return me;
    }

    private static ContentFactory createExcelContentFactory() {
        DefaultContentFactory contentFactory = new DefaultContentFactory();
        contentFactory.addModule(new TextContentFactoryModule());
        contentFactory.addModule(new ShapeContentFactoryModule());
        contentFactory.addModule(new AnchorContentFactoryModule());
        contentFactory.addModule(new DrawableContentFactoryModule());
        contentFactory.addModule(new ImageContentFactoryModule());
        return contentFactory;
    }

    protected MetaElement createImageCell(Element e, long x, long y) {
        ContentFactory contentFactory = this.getLayoutSupport().getContentFactory();
        if (!contentFactory.canHandleContent(e.getContentType())) {
            return null;
        }
        StrictBounds rect = (StrictBounds)e.getStyle().getStyleProperty(ElementStyleSheet.BOUNDS);
        if (rect.getWidth() == 0L || rect.getHeight() == 0L) {
            return null;
        }
        try {
            ElementStyleSheet style = this.createStyleForTextElement(e, x, y);
            Content content = this.createContent(e, style);
            if (EmptyContent.getDefaultEmptyContent().equals(content)) {
                return null;
            }
            ImageContent ic = (ImageContent)content;
            ExcelImageElement me = new ExcelImageElement(ic, style);
            me.setName(e.getName());
            return me;
        }
        catch (ContentCreationException contentCreationException) {
            return null;
        }
    }

    private MetaElement createNumberCell(Element e, long x, long y) {
        RawDataSource nft = (RawDataSource)e.getDataSource();
        Number number = (Number)nft.getRawValue();
        StrictBounds rect = (StrictBounds)e.getStyle().getStyleProperty(ElementStyleSheet.BOUNDS);
        ElementStyleSheet styleSheet = this.createStyleForTextElement(e, x, y);
        styleSheet.setStyleProperty(ElementStyleSheet.EXCEL_DATA_FORMAT_STRING, e.getStyle().getStyleProperty(ElementStyleSheet.EXCEL_DATA_FORMAT_STRING, this.getFormatString(nft)));
        return new ExcelNumberMetaElement(new RawContent(rect, number), styleSheet);
    }

    protected MetaElement createTextCell(Element e, long x, long y) {
        Object o = e.getValue();
        if (o == null) {
            return null;
        }
        DataSource template = e.getDataSource();
        if (template instanceof RawDataSource) {
            RawDataSource rawSource = (RawDataSource)template;
            Object rawValue = rawSource.getRawValue();
            if (rawValue instanceof Date) {
                return this.createDateCell(e, x, y);
            }
            if (rawValue instanceof Number) {
                return this.createNumberCell(e, x, y);
            }
        }
        StrictBounds rect = (StrictBounds)e.getStyle().getStyleProperty(ElementStyleSheet.BOUNDS);
        ExcelMetaElement me = new ExcelMetaElement(new RawContent(rect, String.valueOf(o)), this.createStyleForTextElement(e, x, y));
        me.setName(e.getName());
        return me;
    }

    private String getFormatString(DataSource ds) {
        FormatFilter filter;
        if (ds instanceof NumberFieldTemplate) {
            NumberFieldTemplate nft = (NumberFieldTemplate)ds;
            return nft.getFormat();
        }
        if (ds instanceof DateFieldTemplate) {
            DateFieldTemplate dft = (DateFieldTemplate)ds;
            return dft.getFormat();
        }
        if (ds instanceof DateFormatFilter) {
            filter = (DateFormatFilter)ds;
            if (((DateFormatFilter)filter).getDateFormat() instanceof SimpleDateFormat) {
                SimpleDateFormat dateFormat = (SimpleDateFormat)((DateFormatFilter)filter).getDateFormat();
                return dateFormat.toPattern();
            }
        } else if (ds instanceof NumberFormatFilter && ((NumberFormatFilter)(filter = (NumberFormatFilter)ds)).getNumberFormat() instanceof DecimalFormat) {
            DecimalFormat dateFormat = (DecimalFormat)((NumberFormatFilter)filter).getNumberFormat();
            return dateFormat.toPattern();
        }
        if (ds instanceof DataTarget) {
            DataTarget dt = (DataTarget)((Object)ds);
            return this.getFormatString(dt.getDataSource());
        }
        return null;
    }

    public boolean isDefineDataFormats() {
        return this.defineDataFormats;
    }
}

