/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.xls;

import java.awt.Color;
import org.jfree.report.ElementAlignment;
import org.jfree.report.style.FontDefinition;
import org.jfree.util.ObjectUtilities;

public final class ExcelDataCellStyle {
    private boolean wrapText;
    private ElementAlignment horizontalAlignment;
    private ElementAlignment verticalAlignment;
    private FontDefinition fontDefinition;
    private Color textColor;
    private String dataStyle;
    private int hashCode;

    public ExcelDataCellStyle(FontDefinition fontDefinition, Color textColor, ElementAlignment horizontal, ElementAlignment vertical) {
        this(fontDefinition, textColor, horizontal, vertical, null, false);
    }

    public ExcelDataCellStyle(FontDefinition fontDefinition, Color textColor, ElementAlignment horizontal, ElementAlignment vertical, String dataStyle, boolean wrapText) {
        if (fontDefinition == null) {
            throw new NullPointerException("FontDefinition is null.");
        }
        if (textColor == null) {
            throw new NullPointerException("TextColor is null.");
        }
        if (horizontal == null) {
            throw new NullPointerException("HorizontalAlignment is null.");
        }
        if (vertical == null) {
            throw new NullPointerException("VerticalAlignment is null.");
        }
        this.wrapText = wrapText;
        this.dataStyle = dataStyle;
        this.fontDefinition = fontDefinition;
        this.textColor = textColor;
        this.horizontalAlignment = horizontal;
        this.verticalAlignment = vertical;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExcelDataCellStyle)) {
            return false;
        }
        ExcelDataCellStyle style = (ExcelDataCellStyle)o;
        if (this.wrapText != style.wrapText) {
            return false;
        }
        if (!this.fontDefinition.equals(style.fontDefinition)) {
            return false;
        }
        if (!this.horizontalAlignment.equals(style.horizontalAlignment)) {
            return false;
        }
        if (!this.textColor.equals(style.textColor)) {
            return false;
        }
        if (!this.verticalAlignment.equals(style.verticalAlignment)) {
            return false;
        }
        return ObjectUtilities.equal((Object)this.dataStyle, (Object)style.dataStyle);
    }

    public String getDataStyle() {
        return this.dataStyle;
    }

    public FontDefinition getFontDefinition() {
        return this.fontDefinition;
    }

    public ElementAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public ElementAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.wrapText ? 1 : 0;
            result = 29 * result + this.horizontalAlignment.hashCode();
            result = 29 * result + this.verticalAlignment.hashCode();
            result = 29 * result + this.fontDefinition.hashCode();
            result = 29 * result + this.textColor.hashCode();
            this.hashCode = result = 29 * result + (this.dataStyle != null ? this.dataStyle.hashCode() : 0);
        }
        return this.hashCode;
    }

    public boolean isWrapText() {
        return this.wrapText;
    }
}

