/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.html;

import java.awt.Color;
import java.awt.Stroke;
import org.jfree.report.ElementAlignment;
import org.jfree.report.modules.output.table.base.TableCellBackground;
import org.jfree.report.modules.output.table.html.HtmlStyle;
import org.jfree.report.modules.output.table.html.HtmlStyleCollection;
import org.jfree.report.modules.output.table.html.StyleBuilder;
import org.jfree.report.util.StrokeUtility;
import org.jfree.util.ObjectUtilities;

public class HtmlTableCellStyle
implements HtmlStyle {
    private TableCellBackground background;
    private ElementAlignment verticalAlignment;

    public HtmlTableCellStyle(TableCellBackground background, ElementAlignment verticalAlignment) {
        if (verticalAlignment == null) {
            throw new NullPointerException();
        }
        this.background = background;
        this.verticalAlignment = verticalAlignment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HtmlTableCellStyle that = (HtmlTableCellStyle)o;
        if (!ObjectUtilities.equal((Object)this.background, (Object)that.background)) {
            return false;
        }
        return this.verticalAlignment.equals(that.verticalAlignment);
    }

    public String getCSSString(boolean compact) {
        if (this.background == null) {
            return "font-size: 1pt; vertical-align:" + this.translateVerticalAlignment(this.verticalAlignment) + ";";
        }
        StyleBuilder b = new StyleBuilder(compact);
        b.append("font-size", "1pt");
        Color c = this.background.getColor();
        if (c != null) {
            b.append("background-color", HtmlStyleCollection.getColorString(c));
        }
        if (this.background.getColorTop() != null) {
            b.append("border-top-width", String.valueOf(StrokeUtility.getStrokeWidth(this.background.getBorderStrokeTop())), "pt");
            b.append("border-top-style", HtmlTableCellStyle.translateStrokeStyle(this.background.getBorderStrokeTop()));
            b.append("border-top-color", HtmlStyleCollection.getColorString(this.background.getColorTop()));
        }
        if (this.background.getColorBottom() != null) {
            b.append("border-bottom-width", String.valueOf(StrokeUtility.getStrokeWidth(this.background.getBorderStrokeBottom())), "pt");
            b.append("border-bottom-style", HtmlTableCellStyle.translateStrokeStyle(this.background.getBorderStrokeBottom()));
            b.append("border-bottom-color", HtmlStyleCollection.getColorString(this.background.getColorBottom()));
        }
        if (this.background.getColorLeft() != null) {
            b.append("border-left-width", String.valueOf(StrokeUtility.getStrokeWidth(this.background.getBorderStrokeLeft())), "pt");
            b.append("border-left-style", HtmlTableCellStyle.translateStrokeStyle(this.background.getBorderStrokeLeft()));
            b.append("border-left-color", HtmlStyleCollection.getColorString(this.background.getColorLeft()));
        }
        if (this.background.getColorRight() != null) {
            b.append("border-right-width", String.valueOf(StrokeUtility.getStrokeWidth(this.background.getBorderStrokeRight())), "pt");
            b.append("border-right-style", HtmlTableCellStyle.translateStrokeStyle(this.background.getBorderStrokeRight()));
            b.append("border-right-color", HtmlStyleCollection.getColorString(this.background.getColorRight()));
        }
        b.append("vertical-align", this.translateVerticalAlignment(this.verticalAlignment));
        return b.toString();
    }

    public int hashCode() {
        int result = this.background != null ? this.background.hashCode() : 0;
        result = 29 * result + this.verticalAlignment.hashCode();
        return result;
    }

    public static String translateStrokeStyle(Stroke s) {
        int style = StrokeUtility.getStrokeType(s);
        switch (style) {
            case 1: {
                return "dashed";
            }
            case 2: {
                return "dotted";
            }
            case 3: {
                return "dot-dash";
            }
            case 4: {
                return "dot-dot-dash";
            }
        }
        return "solid";
    }

    private String translateVerticalAlignment(ElementAlignment ea) {
        if (ea == ElementAlignment.BOTTOM) {
            return "bottom";
        }
        if (ea == ElementAlignment.MIDDLE) {
            return "middle";
        }
        return "top";
    }
}

