/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.html;

import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.report.ElementAlignment;
import org.jfree.report.modules.output.table.html.HtmlContentStyle;
import org.jfree.report.modules.output.table.html.HtmlStyle;
import org.jfree.report.modules.output.table.html.HtmlTableCellStyle;
import org.jfree.report.modules.output.table.html.HtmlTableRowStyle;

public class HtmlStyleCollection {
    private final HashMap table = new HashMap();
    private final HashMap reverseTable = new HashMap();
    private int rowCounter;
    private int cellCounter;
    private int nameCounter;
    private static final String ROW_STYLE_PREFIX = "tr.";
    private static final String CELL_STYLE_PREFIX = "td.";
    private static final String GENERIC_STYLE_PREFIX = ".";
    private HtmlTableCellStyle emptyCellStyle = new HtmlTableCellStyle(null, ElementAlignment.TOP);
    static /* synthetic */ Class class$org$jfree$report$modules$output$table$html$util$HtmlColors;

    public HtmlStyleCollection() {
        this.addCellStyle(this.emptyCellStyle);
    }

    public String addCellStyle(HtmlTableCellStyle style) {
        String name = (String)this.table.get(style);
        if (name == null) {
            name = "td.cell-style-" + this.cellCounter;
            this.table.put(style, name);
            this.reverseTable.put(name, style);
            ++this.cellCounter;
        }
        return name;
    }

    public String addContentStyle(HtmlContentStyle style) {
        String name = this.lookupName(style);
        if (name == null) {
            name = this.createName();
            this.table.put(style, name);
            this.reverseTable.put(name, style);
        }
        return name;
    }

    public String addRowStyle(HtmlTableRowStyle style) {
        String name = (String)this.table.get(style);
        if (name == null) {
            name = "tr.row-style-" + this.rowCounter;
            this.table.put(style, name);
            this.reverseTable.put(name, style);
            ++this.rowCounter;
        }
        return name;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void clear() {
        this.table.clear();
        this.reverseTable.clear();
        this.addCellStyle(this.emptyCellStyle);
    }

    private String createName() {
        String name = ".style-" + this.nameCounter;
        ++this.nameCounter;
        return name;
    }

    public static String getColorString(Color color) {
        try {
            Field[] fields = (class$org$jfree$report$modules$output$table$html$util$HtmlColors != null ? class$org$jfree$report$modules$output$table$html$util$HtmlColors : (class$org$jfree$report$modules$output$table$html$util$HtmlColors = HtmlStyleCollection.class$("org.jfree.report.modules.output.table.html.util.HtmlColors"))).getFields();
            int i = 0;
            while (i < fields.length) {
                Field f = fields[i];
                if (Modifier.isPublic(f.getModifiers()) && Modifier.isFinal(f.getModifiers()) && Modifier.isStatic(f.getModifiers())) {
                    String name = f.getName();
                    Object oColor = f.get(null);
                    if (oColor instanceof Color && color.equals(oColor)) {
                        return name;
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        String colorText = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        StringBuffer retval = new StringBuffer(7);
        retval.append("#");
        int fillUp = 6 - colorText.length();
        int i = 0;
        while (i < fillUp) {
            retval.append("0");
            ++i;
        }
        retval.append(colorText);
        return retval.toString();
    }

    public Iterator getDefinedStyles() {
        return this.table.keySet().iterator();
    }

    public HtmlTableCellStyle getEmptyCellStyle() {
        return this.emptyCellStyle;
    }

    public String getPublicName(HtmlStyle style) {
        String styleName = (String)this.table.get(style);
        if (styleName == null) {
            return null;
        }
        if (style instanceof HtmlTableCellStyle) {
            return styleName.substring(CELL_STYLE_PREFIX.length());
        }
        if (style instanceof HtmlTableRowStyle) {
            return styleName.substring(ROW_STYLE_PREFIX.length());
        }
        return styleName.substring(GENERIC_STYLE_PREFIX.length());
    }

    public TreeMap getSortedStyleMap() {
        TreeMap map = new TreeMap();
        Iterator it = this.table.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            map.put(entry.getValue(), entry.getKey());
        }
        return map;
    }

    public boolean isRegistered(HtmlStyle style) {
        String name = this.lookupName(style);
        return name != null;
    }

    public String lookupName(HtmlStyle style) {
        return (String)this.table.get(style);
    }

    public HtmlStyle lookupStyle(String name) {
        if (name == null) {
            return this.emptyCellStyle;
        }
        return (HtmlStyle)this.reverseTable.get(name);
    }
}

