/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.csv;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.modules.output.table.csv.CSVTableProcessor;

public final class CSVReportUtil {
    private CSVReportUtil() {
    }

    public static void createCSV(JFreeReport report, Writer writer) throws ReportProcessingException {
        CSVTableProcessor pr = new CSVTableProcessor(report);
        pr.setWriter(writer);
        pr.processReport();
    }

    public static void createCSV(JFreeReport report, String filename) throws ReportProcessingException, IOException {
        CSVTableProcessor pr = new CSVTableProcessor(report);
        BufferedWriter fout = new BufferedWriter(new FileWriter(filename));
        pr.setWriter(fout);
        pr.processReport();
        ((Writer)fout).close();
    }

    public static void createCSV(JFreeReport report, String filename, String encoding) throws ReportProcessingException, IOException {
        CSVTableProcessor pr = new CSVTableProcessor(report);
        FileOutputStream outstr = new FileOutputStream(filename);
        BufferedWriter fout = new BufferedWriter(new OutputStreamWriter((OutputStream)outstr, encoding));
        pr.setWriter(fout);
        pr.processReport();
        ((Writer)fout).close();
    }
}

