/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.support.itext;

import com.lowagie.text.pdf.BaseFont;
import org.jfree.report.modules.output.support.itext.BaseFontRecordKey;

public final class BaseFontRecord {
    private BaseFont baseFont;
    private String fileName;
    private boolean embedded;
    private boolean trueTypeFont;
    private transient BaseFontRecordKey key;
    private boolean bold;
    private boolean italics;

    public BaseFontRecord(String fileName, boolean trueTypeFont, boolean embedded, BaseFont baseFont, boolean bold, boolean italics) {
        if (baseFont == null) {
            throw new NullPointerException("iText-FontDefinition is null.");
        }
        if (fileName == null) {
            throw new NullPointerException("Logical font name is null.");
        }
        this.trueTypeFont = trueTypeFont;
        this.baseFont = baseFont;
        this.fileName = fileName;
        this.embedded = embedded;
        this.italics = italics;
        this.bold = bold;
    }

    public BaseFontRecordKey createKey() {
        if (this.key == null) {
            this.key = new BaseFontRecordKey(this.getFileName(), this.getEncoding(), this.isEmbedded());
        }
        return this.key;
    }

    public BaseFont getBaseFont() {
        return this.baseFont;
    }

    public String getEncoding() {
        return this.baseFont.getEncoding();
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public boolean isItalics() {
        return this.italics;
    }

    public boolean isTrueTypeFont() {
        return this.trueTypeFont;
    }
}

