/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.plaintext;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.IOException;
import org.jfree.report.modules.output.pageable.plaintext.PlainTextOutputTarget;
import org.jfree.report.modules.output.pageable.plaintext.PlaintextDataChunk;
import org.jfree.report.modules.output.pageable.plaintext.PrinterDriver;
import org.jfree.report.style.FontDefinition;

public class PlainTextPage {
    private PlaintextDataChunk[][] pageBuffer;
    private PrinterDriver driver;
    private int width;
    private int height;
    private Paper paper;
    private String defaultEncoding;

    public PlainTextPage(PageFormat pageFormat, PrinterDriver driver, String defaultEncoding) {
        if (driver == null) {
            throw new NullPointerException("PrinterCommandSet must be defined.");
        }
        if (pageFormat == null) {
            throw new NullPointerException("PageFormat must be defined.");
        }
        if (defaultEncoding == null) {
            throw new NullPointerException("DefaultEncoding must be defined.");
        }
        float characterWidthInPoint = 72.0f / driver.getCharactersPerInch();
        float characterHeightInPoint = 72.0f / driver.getLinesPerInch();
        int currentPageHeight = PlainTextOutputTarget.correctedDivisionFloor((float)pageFormat.getImageableHeight(), characterHeightInPoint);
        int currentPageWidth = PlainTextOutputTarget.correctedDivisionFloor((float)pageFormat.getImageableWidth(), characterWidthInPoint);
        this.pageBuffer = new PlaintextDataChunk[currentPageWidth][currentPageHeight];
        this.width = currentPageWidth;
        this.height = currentPageHeight;
        this.paper = pageFormat.getPaper();
        this.driver = driver;
        this.defaultEncoding = defaultEncoding;
    }

    public void addTextChunk(int x, int y, int w, String text, FontDefinition format) {
        if (text.length() == 0) {
            return;
        }
        if (x < 0) {
            throw new IllegalArgumentException("X < 0");
        }
        if (y < 0) {
            throw new IllegalArgumentException("y < 0");
        }
        if (w < 0) {
            throw new IllegalArgumentException("w < 0");
        }
        if (x + w > this.width) {
            throw new IllegalArgumentException("X+W [" + (x + w) + "] > bufferWidth [" + this.width + "]");
        }
        if (y >= this.height) {
            throw new IllegalArgumentException("Y > bufferHeight: " + text + " y=" + y + " h=" + this.height);
        }
        PlaintextDataChunk chunk = new PlaintextDataChunk(text, format, this.defaultEncoding, x, y, w);
        int i = 0;
        while (i < w) {
            if (this.pageBuffer[x + i][y] == null) {
                this.pageBuffer[x + i][y] = chunk;
            }
            ++i;
        }
    }

    private PlaintextDataChunk getChunk(int x, int y) {
        return this.pageBuffer[x][y];
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void writePage() throws IOException {
        this.driver.startPage(this.paper, this.defaultEncoding);
        int y = 0;
        while (y < this.height) {
            this.driver.startLine();
            int emptyChunkCount = 0;
            boolean overflow = false;
            int x = 0;
            while (x < this.width) {
                PlaintextDataChunk chunk = this.getChunk(x, y);
                if (chunk == null) {
                    ++emptyChunkCount;
                } else if (chunk.getX() == x) {
                    if (emptyChunkCount != 0) {
                        this.driver.printEmptyChunk(emptyChunkCount);
                        emptyChunkCount = 0;
                    }
                    this.driver.printChunk(chunk);
                    if ((x += chunk.getWidth() - 1) == this.width - 1) {
                        overflow = true;
                    }
                }
                ++x;
            }
            if (y == this.height - 1) {
                this.driver.endPage(overflow);
            } else {
                this.driver.endLine(overflow);
            }
            ++y;
        }
        this.driver.flush();
    }
}

