/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.plaintext;

import java.awt.print.Paper;
import java.io.IOException;
import java.io.OutputStream;
import org.jfree.report.modules.output.pageable.plaintext.DefaultFontMapper;
import org.jfree.report.modules.output.pageable.plaintext.EncodingUtilities;
import org.jfree.report.modules.output.pageable.plaintext.FontMapper;
import org.jfree.report.modules.output.pageable.plaintext.PlaintextDataChunk;
import org.jfree.report.modules.output.pageable.plaintext.PrinterDriver;
import org.jfree.report.modules.output.pageable.plaintext.PrinterSpecification;
import org.jfree.report.modules.output.pageable.plaintext.PrinterSpecificationManager;
import org.jfree.report.style.FontDefinition;
import org.jfree.report.util.PageFormatFactory;

public abstract class AbstractEpsonPrinterDriver
implements PrinterDriver {
    public static final String OP_NO_ASSIGN_CHAR_TABLE = "no.assign.character.table";
    public static final String FONT_15_CPI = "Epson.Font-15CPI-available";
    private PrinterSpecification printerSpecification;
    private FontMapper fontMapper;
    private OutputStream out;
    private float charsPerInch;
    private float linesPerInch;
    private EncodingUtilities encodingUtilities;
    private boolean firstPage;
    private byte fallBackCharset;
    private int borderTop;
    private DriverState driverState;

    protected AbstractEpsonPrinterDriver(OutputStream out, float charsPerInch, float linesPerInch, String printerModel) {
        this.out = out;
        this.charsPerInch = charsPerInch;
        this.linesPerInch = linesPerInch;
        this.printerSpecification = this.lookupPrinterSpecification(printerModel);
        this.fontMapper = new DefaultFontMapper();
        this.firstPage = true;
        this.driverState = new DriverState();
        if (!this.isValidCPI(charsPerInch)) {
            throw new IllegalArgumentException("The given CPI of '" + charsPerInch + "' is invalid for the selected printer model ('" + printerModel + "'.");
        }
    }

    public void endLine(boolean overflow) throws IOException {
        if (!overflow) {
            this.out.write(13);
            this.out.write(10);
        } else {
            this.out.write(127);
        }
    }

    public void endPage(boolean overflow) throws IOException {
        if (!overflow) {
            this.out.write(12);
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public float getCharactersPerInch() {
        return this.charsPerInch;
    }

    public DriverState getDriverState() {
        return this.driverState;
    }

    protected EncodingUtilities getEncodingUtilities(String encoding) throws IOException {
        if (this.encodingUtilities != null && this.encodingUtilities.getEncoding().equals(encoding)) {
            return this.encodingUtilities;
        }
        this.encodingUtilities = new EncodingUtilities(encoding);
        this.sendDefineCodepage(encoding, 0);
        return this.encodingUtilities;
    }

    public byte getFallBackCharset() {
        return this.fallBackCharset;
    }

    public FontMapper getFontMapper() {
        return this.fontMapper;
    }

    public float getLinesPerInch() {
        return this.linesPerInch;
    }

    protected OutputStream getOut() {
        return this.out;
    }

    public PrinterSpecification getPrinterSpecification() {
        return this.printerSpecification;
    }

    protected abstract PrinterSpecificationManager getPrinterSpecificationManager();

    protected int getSelectedCharacterTable() {
        return 0;
    }

    protected boolean isFirstPage() {
        return this.firstPage;
    }

    private boolean isValidCPI(float charsPerInch) {
        if (charsPerInch == 10.0f) {
            return true;
        }
        if (charsPerInch == 12.0f) {
            return true;
        }
        if (charsPerInch == 17.14f) {
            return true;
        }
        if (charsPerInch == 20.0f) {
            return true;
        }
        return charsPerInch == 15.0f && this.getPrinterSpecification().isFeatureAvailable(FONT_15_CPI);
    }

    private PrinterSpecification lookupPrinterSpecification(String model) {
        PrinterSpecificationManager printerSpecificationManager = this.getPrinterSpecificationManager();
        if (model == null) {
            return PrinterSpecificationManager.getGenericPrinter();
        }
        PrinterSpecification printerModel = printerSpecificationManager.getPrinter(model);
        if (printerModel == null) {
            throw new IllegalArgumentException("The printer model is not supported.");
        }
        return printerModel;
    }

    public void printChunk(PlaintextDataChunk chunk) throws IOException {
        String encoding = chunk.getEncoding();
        String text = chunk.getText().substring(0, chunk.getWidth());
        FontDefinition fd = chunk.getFont();
        this.sendDefineFont(this.fontMapper.getPrinterFont(fd));
        this.sendFontStyle(fd.isBold(), fd.isItalic(), fd.isUnderline(), fd.isStrikeThrough());
        this.getEncodingUtilities(encoding).writeEncodedText(text, this.out);
    }

    public void printEmptyChunk(int count) throws IOException {
        this.sendFontStyle(this.getDriverState().isBold(), this.getDriverState().isItalic(), false, false);
        int i = 0;
        while (i < count) {
            this.out.write(32);
            ++i;
        }
    }

    public void printRaw(byte[] raw) throws IOException {
        this.out.write(raw);
    }

    protected void sendDefineCharacterWidth(float charactersPerInch) throws IOException {
        if (charactersPerInch == 10.0f) {
            this.getOut().write(18);
            this.getOut().write(27);
            this.getOut().write(80);
        } else if (charactersPerInch == 12.0f) {
            this.getOut().write(18);
            this.getOut().write(27);
            this.getOut().write(77);
        } else if (charactersPerInch == 15.0f) {
            this.getOut().write(18);
            this.getOut().write(27);
            this.getOut().write(103);
        } else if (charactersPerInch == 17.14f) {
            this.getOut().write(15);
            this.getOut().write(27);
            this.getOut().write(80);
        } else if (charactersPerInch == 20.0f) {
            this.getOut().write(15);
            this.getOut().write(27);
            this.getOut().write(77);
        } else {
            throw new IllegalArgumentException("The given character width is invalid");
        }
    }

    protected void sendDefineCodepage(String encoding, int characterTable) throws IOException {
        if (this.getPrinterSpecification().isFeatureAvailable(OP_NO_ASSIGN_CHAR_TABLE)) {
            this.out.write(27);
            this.out.write(82);
            this.out.write(this.getFallBackCharset());
        } else {
            byte[] cp = this.getPrinterSpecification().getEncoding(encoding).getCode();
            this.out.write(27);
            this.out.write(40);
            this.out.write(116);
            this.out.write(3);
            this.out.write(0);
            this.out.write(characterTable);
            this.out.write(cp);
        }
        this.out.write(27);
        this.out.write(116);
        this.out.write(0);
    }

    protected void sendDefineFont(byte printerFont) throws IOException {
        if (this.getDriverState().getFont() != printerFont) {
            this.getOut().write(27);
            this.getOut().write(107);
            this.getOut().write(printerFont);
            this.getDriverState().setFont(printerFont);
        }
    }

    protected void sendDefineHorizontalBorders(int left, int right) throws IOException {
        if (left < 256) {
            this.getOut().write(27);
            this.getOut().write(108);
            this.getOut().write(left);
            this.getDriverState().setManualLeftBorder(0);
        } else {
            this.getOut().write(27);
            this.getOut().write(108);
            this.getOut().write(255);
            this.getDriverState().setManualLeftBorder(left - 255);
        }
    }

    protected abstract void sendDefineLineSpacing(float var1) throws IOException;

    protected void sendDefinePageLengthInLines(int paperSizeInLines) throws IOException {
        this.getOut().write(27);
        this.getOut().write(67);
        this.getOut().write(paperSizeInLines);
    }

    protected void sendDefineUserCharacters() {
    }

    protected abstract void sendFontStyle(boolean var1, boolean var2, boolean var3, boolean var4) throws IOException;

    protected void sendResetPrinter() throws IOException {
        this.out.write(27);
        this.out.write(64);
    }

    public void setFallBackCharset(byte fallBackCharset) {
        this.fallBackCharset = fallBackCharset;
    }

    public void setFontMapper(FontMapper fontMapper) {
        this.fontMapper = fontMapper;
    }

    public void startLine() throws IOException {
        this.sendFontStyle(false, false, false, false);
        int manualLeftBorder = this.getDriverState().getManualLeftBorder();
        int i = 0;
        while (i < manualLeftBorder) {
            this.out.write(32);
            ++i;
        }
    }

    public void startPage(Paper paper, String encoding) throws IOException {
        float lineHeightPoints = 72.0f / this.getLinesPerInch();
        float charWidthPoints = 72.0f / this.getCharactersPerInch();
        this.sendResetPrinter();
        this.driverState.reset();
        this.sendDefineLineSpacing(lineHeightPoints);
        int lines = (int)(paper.getHeight() / 72.0 * (double)this.getLinesPerInch());
        this.sendDefinePageLengthInLines(lines);
        this.sendDefineCharacterWidth(this.getCharactersPerInch());
        PageFormatFactory fact = PageFormatFactory.getInstance();
        int borderLeft = (int)(fact.getLeftBorder(paper) / (double)charWidthPoints);
        int borderRight = (int)(fact.getRightBorder(paper) / (double)charWidthPoints);
        this.sendDefineHorizontalBorders(borderLeft, borderRight);
        this.borderTop = (int)(fact.getTopBorder(paper) / (double)lineHeightPoints);
        int i = 0;
        while (i < this.borderTop) {
            this.startLine();
            this.endLine(false);
            ++i;
        }
    }

    protected static class DriverState {
        private boolean bold;
        private boolean underline;
        private boolean italic;
        private boolean strikethrough;
        private byte font;
        private int manualLeftBorder;

        public byte getFont() {
            return this.font;
        }

        public int getManualLeftBorder() {
            return this.manualLeftBorder;
        }

        public boolean isBold() {
            return this.bold;
        }

        public boolean isItalic() {
            return this.italic;
        }

        public boolean isStrikethrough() {
            return this.strikethrough;
        }

        public boolean isUnderline() {
            return this.underline;
        }

        public void reset() {
            this.bold = false;
            this.italic = false;
            this.strikethrough = false;
            this.underline = false;
            this.font = 0;
            this.manualLeftBorder = 0;
        }

        public void setBold(boolean bold) {
            this.bold = bold;
        }

        public void setFont(byte font) {
            this.font = font;
        }

        public void setItalic(boolean italic) {
            this.italic = italic;
        }

        public void setManualLeftBorder(int manualLeftBorder) {
            this.manualLeftBorder = manualLeftBorder;
        }

        public void setStrikethrough(boolean strikethrough) {
            this.strikethrough = strikethrough;
        }

        public void setUnderline(boolean underline) {
            this.underline = underline;
        }
    }
}

