/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.csv;

import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportEventException;
import org.jfree.report.ReportInterruptedException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.modules.output.csv.CSVWriter;
import org.jfree.report.states.FinishState;
import org.jfree.report.states.ReportState;
import org.jfree.report.states.ReportStateProgress;
import org.jfree.report.states.StartState;
import org.jfree.report.util.NullOutputStream;
import org.jfree.report.util.ReportConfigurationUtil;
import org.jfree.util.Configuration;

public class CSVProcessor {
    public static final String CSV_SEPARATOR = "org.jfree.report.modules.output.csv.Separator";
    public static final String CSV_DATAROWNAME = "org.jfree.report.modules.output.csv.WriteDatarowNames";
    public static final String CSV_WRITE_STATECOLUMNS = "org.jfree.report.modules.output.csv.WriteStateColumns";
    public static final String CSV_ENABLE_REPORTHEADER = "org.jfree.report.modules.output.csv.EnableReportHeader";
    public static final String CSV_ENABLE_REPORTFOOTER = "org.jfree.report.modules.output.csv.EnableReportFooter";
    public static final String CSV_ENABLE_GROUPHEADERS = "org.jfree.report.modules.output.csv.EnableGroupHeaders";
    public static final String CSV_ENABLE_GROUPFOOTERS = "org.jfree.report.modules.output.csv.EnableGroupFooters";
    public static final String CSV_ENABLE_ITEMBANDS = "org.jfree.report.modules.output.csv.EnableItembands";
    private static final String CSV_WRITER = "org.jfree.report.modules.output.csv.csv-writer";
    private Writer writer;
    private JFreeReport report;
    private boolean handleInterruptedState;

    public CSVProcessor(JFreeReport report) throws ReportProcessingException {
        this(report, report.getReportConfiguration().getConfigProperty(CSV_SEPARATOR, ","));
    }

    public CSVProcessor(JFreeReport report, String separator) throws ReportProcessingException {
        this(report, separator, CSVProcessor.queryBoolConfig((Configuration)report.getReportConfiguration(), CSV_DATAROWNAME));
    }

    public CSVProcessor(JFreeReport report, String separator, boolean writeDataRowNames) throws ReportProcessingException {
        if (report == null) {
            throw new NullPointerException();
        }
        try {
            this.report = (JFreeReport)report.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ReportProcessingException("Initial Clone of Report failed");
        }
        CSVWriter lm = new CSVWriter();
        lm.setName(CSV_WRITER);
        lm.setSeparator(separator);
        lm.setWriteDataRowNames(writeDataRowNames);
        ModifiableConfiguration config = report.getReportConfiguration();
        lm.setWriteStateColumns(CSVProcessor.queryBoolConfig((Configuration)config, CSV_WRITE_STATECOLUMNS));
        lm.setEnableReportHeader(CSVProcessor.queryBoolConfig((Configuration)config, CSV_ENABLE_REPORTHEADER));
        lm.setEnableReportFooter(CSVProcessor.queryBoolConfig((Configuration)config, CSV_ENABLE_REPORTFOOTER));
        lm.setEnableGroupHeader(CSVProcessor.queryBoolConfig((Configuration)config, CSV_ENABLE_GROUPHEADERS));
        lm.setEnableGroupFooter(CSVProcessor.queryBoolConfig((Configuration)config, CSV_ENABLE_GROUPFOOTERS));
        lm.setEnableItemband(CSVProcessor.queryBoolConfig((Configuration)config, CSV_ENABLE_ITEMBANDS));
        this.report.addExpression(lm);
    }

    protected void checkInterrupted() throws ReportInterruptedException {
        if (this.isHandleInterruptedState() && Thread.interrupted()) {
            throw new ReportInterruptedException("Current thread is interrupted. Returning.");
        }
    }

    protected JFreeReport getReport() {
        return this.report;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public boolean isHandleInterruptedState() {
        return this.handleInterruptedState;
    }

    public void processReport() throws ReportProcessingException {
        if (this.writer == null) {
            throw new IllegalStateException("No writer defined");
        }
        try {
            ReportState state = this.repaginate();
            CSVWriter w = (CSVWriter)state.getDataRow().get(CSV_WRITER);
            w.setWriter(this.getWriter());
            boolean failOnError = ReportConfigurationUtil.isStrictErrorHandling((Configuration)this.getReport().getReportConfiguration());
            ReportStateProgress progress = null;
            while (!state.isFinish()) {
                this.checkInterrupted();
                progress = state.createStateProgress(progress);
                state = state.advance();
                if (failOnError && state.isErrorOccured()) {
                    throw new ReportEventException("Failed to dispatch an event.", state.getErrors());
                }
                if (state.isFinish() || state.isProceeding(progress)) continue;
                throw new ReportProcessingException("State did not proceed, bailing out!");
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ReportProcessingException("StateCopy was not supported");
        }
    }

    private static boolean queryBoolConfig(Configuration config, String name) {
        return config.getConfigProperty(name, "false").equals("true");
    }

    private ReportState repaginate() throws ReportProcessingException, CloneNotSupportedException {
        boolean hasNext;
        StartState startState;
        try {
            startState = new StartState(this.getReport(), "data/csv");
        }
        catch (CloneNotSupportedException e) {
            throw new ReportProcessingException("Unable to clone the start state.", e);
        }
        ReportState state = startState;
        state.setProperty("report.preparerun", Boolean.TRUE);
        CSVWriter w = (CSVWriter)state.getDataRow().get(CSV_WRITER);
        w.setWriter(new OutputStreamWriter(new NullOutputStream()));
        Iterator it = startState.getLevels();
        if (!it.hasNext()) {
            throw new IllegalStateException("No functions defined, invalid implementation.");
        }
        ReportState retval = null;
        int level = (Integer)it.next();
        ReportStateProgress progress = null;
        do {
            if (level == -1) {
                retval = (ReportState)state.clone();
            }
            boolean failOnError = level == -1 && ReportConfigurationUtil.isStrictErrorHandling((Configuration)this.getReport().getReportConfiguration());
            while (!state.isFinish()) {
                this.checkInterrupted();
                progress = state.createStateProgress(progress);
                state = state.advance();
                if (failOnError && state.isErrorOccured()) {
                    throw new ReportEventException("Failed to dispatch an event.", state.getErrors());
                }
                if (state.isFinish() || state.isProceeding(progress)) continue;
                throw new ReportProcessingException("State did not proceed, bailing out!");
            }
            hasNext = it.hasNext();
            if (!hasNext) continue;
            level = (Integer)it.next();
            if (state instanceof FinishState) {
                state = new StartState((FinishState)state, level);
                continue;
            }
            throw new IllegalStateException("The processing did not produce an finish state");
        } while (hasNext);
        state.setProperty("report.preparerun", Boolean.FALSE);
        StartState sretval = (StartState)retval;
        if (sretval == null) {
            throw new IllegalStateException("There was no valid pagination done.");
        }
        sretval.resetState();
        return sretval;
    }

    public void setHandleInterruptedState(boolean handleInterruptedState) {
        this.handleInterruptedState = handleInterruptedState;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }
}

