/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.tablemodel;

import javax.swing.table.AbstractTableModel;

public class CSVTableModel
extends AbstractTableModel {
    private String[] columnNames = null;
    private int rowCount = 0;
    private int maxColumnCount = 0;
    private Object[][] data;

    public int getColumnCount() {
        if (this.columnNames != null) {
            return this.columnNames.length;
        }
        return this.maxColumnCount;
    }

    public String getColumnName(int column) {
        if (this.columnNames != null) {
            return this.columnNames[column];
        }
        if (column >= this.maxColumnCount) {
            throw new IllegalArgumentException("Column (" + column + ") does not exist");
        }
        return "COLUMN_" + column;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public Object[][] getData() {
        return this.data;
    }

    public int getMaxColumnCount() {
        return this.maxColumnCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object[] line = this.data[rowIndex];
        if (line.length < columnIndex) {
            return null;
        }
        return line[columnIndex];
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public void setData(Object[][] data) {
        this.data = data;
    }

    public void setMaxColumnCount(int maxColumnCount) {
        if (this.maxColumnCount < maxColumnCount) {
            this.maxColumnCount = maxColumnCount;
        }
    }
}

