/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.configstore.base;

import org.jfree.report.modules.misc.configstore.base.ConfigStorage;
import org.jfree.report.modules.misc.configstore.base.NullConfigStorage;

public final class ConfigFactory {
    public static final String CONFIG_TARGET_KEY = "org.jfree.report.ConfigStore";
    private static ConfigFactory factory;
    private ConfigStorage userStorage;
    private ConfigStorage systemStorage;

    private ConfigFactory() {
    }

    public void defineSystemStorage(ConfigStorage storage) {
        if (storage == null) {
            throw new NullPointerException();
        }
        this.systemStorage = storage;
    }

    public void defineUserStorage(ConfigStorage storage) {
        if (storage == null) {
            throw new NullPointerException();
        }
        this.userStorage = storage;
    }

    public static String encodePath(String path) {
        char[] data = path.toCharArray();
        StringBuffer encoded = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            if (data[i] == '$') {
                encoded.append('$');
                encoded.append('$');
            } else if (!Character.isJavaIdentifierPart(data[i])) {
                encoded.append('$');
                String hex = Integer.toHexString(data[i]);
                int x = hex.length();
                while (x < 4) {
                    encoded.append('0');
                    ++x;
                }
                encoded.append(hex);
            } else {
                encoded.append(data[i]);
            }
            ++i;
        }
        return encoded.toString();
    }

    public static synchronized ConfigFactory getInstance() {
        if (factory == null) {
            factory = new ConfigFactory();
            factory.defineSystemStorage(new NullConfigStorage());
            factory.defineUserStorage(new NullConfigStorage());
        }
        return factory;
    }

    public ConfigStorage getSystemStorage() {
        return this.systemStorage;
    }

    public ConfigStorage getUserStorage() {
        return this.userStorage;
    }

    public static boolean isValidPath(String path) {
        char[] data = path.toCharArray();
        int i = 0;
        while (i < data.length) {
            if (!Character.isJavaIdentifierPart(data[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

