/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.plaintext;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jfree.report.JFreeReport;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.modules.gui.base.AbstractExportPlugin;
import org.jfree.report.modules.gui.base.PreviewProxy;
import org.jfree.report.modules.gui.base.PreviewProxyBase;
import org.jfree.report.modules.gui.base.ReportProgressDialog;
import org.jfree.report.modules.gui.plaintext.PlainTextExportDialog;
import org.jfree.report.modules.gui.plaintext.PlainTextExportTask;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.ResourceBundleSupport;

public class PlainTextExportPlugin
extends AbstractExportPlugin {
    private PlainTextExportDialog exportDialog;
    private final ResourceBundleSupport resources = new ResourceBundleSupport("org.jfree.report.modules.gui.plaintext.resources/plaintext-export-resources");
    public static final String BASE_RESOURCE_CLASS = "org.jfree.report.modules.gui.plaintext.resources/plaintext-export-resources";
    public static final String PROGRESS_DIALOG_ENABLE_KEY = "org.jfree.report.modules.gui.plaintext.ProgressDialogEnabled";

    protected ReportProgressDialog createProgressDialog() {
        ReportProgressDialog progressDialog = super.createProgressDialog();
        progressDialog.setDefaultCloseOperation(0);
        progressDialog.setTitle(this.resources.getString("plaintext-export.progressdialog.title"));
        progressDialog.setMessage(this.resources.getString("plaintext-export.progressdialog.message"));
        progressDialog.pack();
        RefineryUtilities.positionFrameRandomly((Window)progressDialog);
        return progressDialog;
    }

    public KeyStroke getAcceleratorKey() {
        return this.resources.getKeyStroke("action.export-to-plaintext.accelerator");
    }

    public String getDisplayName() {
        return this.resources.getString("action.export-to-plaintext.name");
    }

    protected PlainTextExportDialog getExportDialog() {
        if (this.exportDialog == null) {
            PreviewProxyBase base;
            Window w;
            PreviewProxy proxy = super.getProxy();
            this.exportDialog = proxy instanceof Frame ? new PlainTextExportDialog((Frame)((Object)proxy)) : (proxy instanceof Dialog ? new PlainTextExportDialog((Dialog)((Object)proxy)) : (proxy != null ? ((w = PreviewProxyBase.getWindowAncestor(base = proxy.getBase())) instanceof Frame ? new PlainTextExportDialog((Frame)w) : (w instanceof Dialog ? new PlainTextExportDialog((Dialog)w) : new PlainTextExportDialog())) : new PlainTextExportDialog()));
            this.exportDialog.pack();
        }
        return this.exportDialog;
    }

    public Icon getLargeIcon() {
        return this.getSkin().getIcon("action.export-to-plaintext.icon", true, true);
    }

    public Integer getMnemonicKey() {
        return this.resources.getMnemonic("action.export-to-plaintext.mnemonic");
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }

    public String getShortDescription() {
        return this.resources.getString("action.export-to-plaintext.description");
    }

    public Icon getSmallIcon() {
        return this.getSkin().getIcon("action.export-to-plaintext.small-icon", true, false);
    }

    public boolean isAddToToolbar() {
        return JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty("org.jfree.report.modules.gui.plaintext.AddToToolbar", "false").equals("true");
    }

    public boolean isSeparated() {
        return JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty("org.jfree.report.modules.gui.plaintext.Separated", "false").equals("true");
    }

    public boolean performExport(JFreeReport report) {
        PlainTextExportDialog exportDialog = this.getExportDialog();
        boolean result = exportDialog.performQueryForExport(report);
        if (!result) {
            return this.handleExportResult(true);
        }
        ReportProgressDialog progressDialog = report.getReportConfiguration().getConfigProperty(PROGRESS_DIALOG_ENABLE_KEY, "false").equals("true") ? this.createProgressDialog() : null;
        String selectedPrinterModel = exportDialog.getSelectedPrinter() == 1 ? exportDialog.getSelected9PinPrinterModel() : (exportDialog.getSelectedPrinter() == 3 ? exportDialog.getSelected24PinPrinterModel() : null);
        PlainTextExportTask task = new PlainTextExportTask(exportDialog.getFilename(), progressDialog, exportDialog.getSelectedPrinter(), report, selectedPrinterModel);
        task.addExportTaskListener(new AbstractExportPlugin.DefaultExportTaskListener());
        this.delegateTask(task);
        return this.handleExportResult(task);
    }
}

