/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.html;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jfree.report.JFreeReport;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.modules.gui.base.AbstractExportPlugin;
import org.jfree.report.modules.gui.base.ExportTask;
import org.jfree.report.modules.gui.base.PreviewProxy;
import org.jfree.report.modules.gui.base.PreviewProxyBase;
import org.jfree.report.modules.gui.base.ReportProgressDialog;
import org.jfree.report.modules.gui.html.HtmlDirExportTask;
import org.jfree.report.modules.gui.html.HtmlExportDialog;
import org.jfree.report.modules.gui.html.HtmlStreamExportTask;
import org.jfree.report.modules.gui.html.HtmlZipExportTask;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.ResourceBundleSupport;

public class HtmlExportPlugin
extends AbstractExportPlugin {
    private HtmlExportDialog exportDialog;
    private final ResourceBundleSupport resources = new ResourceBundleSupport("org.jfree.report.modules.gui.html.resources.html-export-resources");
    public static final String BASE_RESOURCE_CLASS = "org.jfree.report.modules.gui.html.resources.html-export-resources";
    public static final String PROGRESS_DIALOG_ENABLE_KEY = "org.jfree.report.modules.gui.html.ProgressDialogEnabled";

    protected ReportProgressDialog createProgressDialog() {
        ReportProgressDialog progressDialog = super.createProgressDialog();
        progressDialog.setDefaultCloseOperation(0);
        progressDialog.setTitle(this.resources.getString("html-export.progressdialog.title"));
        progressDialog.setMessage(this.resources.getString("html-export.progressdialog.message"));
        progressDialog.pack();
        RefineryUtilities.positionFrameRandomly((Window)progressDialog);
        return progressDialog;
    }

    public KeyStroke getAcceleratorKey() {
        return this.resources.getKeyStroke("action.export-to-html.accelerator");
    }

    public String getDisplayName() {
        return this.resources.getString("action.export-to-html.name");
    }

    protected HtmlExportDialog getExportDialog() {
        if (this.exportDialog == null) {
            PreviewProxyBase base;
            Window w;
            PreviewProxy proxy = super.getProxy();
            this.exportDialog = proxy instanceof Frame ? new HtmlExportDialog((Frame)((Object)proxy)) : (proxy instanceof Dialog ? new HtmlExportDialog((Dialog)((Object)proxy)) : (proxy != null ? ((w = PreviewProxyBase.getWindowAncestor(base = proxy.getBase())) instanceof Frame ? new HtmlExportDialog((Frame)w) : (w instanceof Dialog ? new HtmlExportDialog((Dialog)w) : new HtmlExportDialog())) : new HtmlExportDialog()));
            this.exportDialog.pack();
        }
        return this.exportDialog;
    }

    public Icon getLargeIcon() {
        return this.getSkin().getIcon("action.export-to-html.icon", true, true);
    }

    public Integer getMnemonicKey() {
        return this.resources.getMnemonic("action.export-to-html.mnemonic");
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }

    public String getShortDescription() {
        return this.resources.getString("action.export-to-html.description");
    }

    public Icon getSmallIcon() {
        return this.getSkin().getIcon("action.export-to-html.small-icon", true, false);
    }

    public boolean isAddToToolbar() {
        return JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty("org.jfree.report.modules.gui.html.AddToToolbar", "false").equals("true");
    }

    public boolean isSeparated() {
        return JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty("org.jfree.report.modules.gui.html.Separated", "false").equals("true");
    }

    public boolean performExport(JFreeReport report) {
        ExportTask task;
        HtmlExportDialog exportDialog = this.getExportDialog();
        boolean result = exportDialog.performQueryForExport(report);
        if (!result) {
            return this.handleExportResult(true);
        }
        ReportProgressDialog progressDialog = report.getReportConfiguration().getConfigProperty(PROGRESS_DIALOG_ENABLE_KEY, "false").equals("true") ? this.createProgressDialog() : null;
        switch (exportDialog.getSelectedExportMethod()) {
            case 1: {
                task = new HtmlDirExportTask(exportDialog.getFilename(), exportDialog.getDataFilename(), progressDialog, report);
                break;
            }
            case 0: {
                task = new HtmlStreamExportTask(exportDialog.getFilename(), progressDialog, report);
                break;
            }
            case 2: {
                task = new HtmlZipExportTask(exportDialog.getFilename(), exportDialog.getDataFilename(), progressDialog, report);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected export method found.");
            }
        }
        task.addExportTaskListener(new AbstractExportPlugin.DefaultExportTaskListener());
        this.delegateTask(task);
        return this.handleExportResult(task);
    }
}

